/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.RawProtobufMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.impl.AbstractMarshallerCodeGenerator;
import org.infinispan.protostream.annotations.impl.GeneratedMarshallerBase;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoEnumTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoFieldMetadata;
import org.infinispan.protostream.annotations.impl.ProtoMessageTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.processor.AutoProtoSchemaBuilderAnnotationProcessor;
import org.infinispan.protostream.annotations.impl.processor.GeneratedFilesWriter;
import org.infinispan.protostream.annotations.impl.processor.types.HasModelElement;
import org.infinispan.protostream.annotations.impl.types.XTypeFactory;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.EnumMarshallerDelegate;
import org.infinispan.protostream.impl.Log;

final class MarshallerSourceCodeGenerator
extends AbstractMarshallerCodeGenerator {
    private static final Log log = Log.LogFactory.getLog(MarshallerSourceCodeGenerator.class);
    private static final String DIGEST_ALG = "SHA-256";
    private final GeneratedFilesWriter generatedFilesWriter;
    private final Set<String> generatedClasses = new LinkedHashSet<String>();

    MarshallerSourceCodeGenerator(GeneratedFilesWriter generatedFilesWriter, XTypeFactory typeFactory, String protobufSchemaPackage) {
        super(typeFactory, protobufSchemaPackage);
        this.generatedFilesWriter = generatedFilesWriter;
    }

    public void generateMarshaller(SerializationContext serCtx, ProtoTypeMetadata ptm) throws IOException {
        if (ptm instanceof ProtoMessageTypeMetadata) {
            this.generateMessageMarshaller((ProtoMessageTypeMetadata)ptm);
        } else if (ptm instanceof ProtoEnumTypeMetadata) {
            this.generateEnumMarshaller((ProtoEnumTypeMetadata)ptm);
        }
    }

    private String makeUniqueMarshallerClassName(ProtoTypeMetadata ptm) {
        String hash = MarshallerSourceCodeGenerator.hashStrings(ptm.getAnnotatedClass().getName(), this.makeQualifiedTypeName(ptm.getFullName()));
        return ptm.getAnnotatedClass().getSimpleName() + "$___Marshaller_" + hash;
    }

    private static String hashStrings(String ... strings) {
        try {
            MessageDigest md = MessageDigest.getInstance(DIGEST_ALG);
            for (int i = 0; i < strings.length; ++i) {
                if (i > 0) {
                    md.update((byte)0);
                }
                byte[] bytes = strings[i].getBytes(StandardCharsets.UTF_8);
                md.update(bytes);
            }
            byte[] digest = md.digest();
            return new BigInteger(1, digest).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to compute SHA-256 digest of strings", e);
        }
    }

    private void generateEnumMarshaller(ProtoEnumTypeMetadata petm) throws IOException {
        String fqn;
        String marshallerClassName = this.makeUniqueMarshallerClassName((ProtoTypeMetadata)petm);
        if (log.isTraceEnabled()) {
            log.tracef("Generating enum marshaller %s for %s", (Object)marshallerClassName, (Object)petm.getJavaClass().getName());
        }
        IndentWriter iw = new IndentWriter();
        this.addFileHeader(iw, petm.getAnnotatedClassName());
        if (petm.getAnnotatedClass().getPackageName() != null) {
            fqn = petm.getAnnotatedClass().getPackageName() + '.' + marshallerClassName;
            iw.append((CharSequence)"package ").append((CharSequence)petm.getAnnotatedClass().getPackageName()).append((CharSequence)";\n\n");
        } else {
            fqn = marshallerClassName;
        }
        if (petm.getJavaClass().getPackageName() != null) {
            iw.append((CharSequence)"import ").append((CharSequence)petm.getJavaClassName()).append((CharSequence)";\n\n");
        }
        iw.append((CharSequence)"public final class ").append((CharSequence)marshallerClassName).append((CharSequence)" implements ").append((CharSequence)EnumMarshaller.class.getName()).append('<').append((CharSequence)petm.getJavaClassName()).append((CharSequence)"> {\n\n");
        iw.inc();
        iw.append((CharSequence)"@Override\npublic Class<").append((CharSequence)petm.getJavaClassName()).append((CharSequence)"> getJavaClass() { return ").append((CharSequence)petm.getJavaClassName()).append((CharSequence)".class; }\n\n");
        iw.append((CharSequence)"@Override\npublic String getTypeName() { return \"").append((CharSequence)this.makeQualifiedTypeName(petm.getFullName())).append((CharSequence)"\"; }\n\n");
        String decodeSrc = this.generateEnumDecodeMethodBody(petm);
        String decodeSig = "public " + petm.getJavaClassName() + " decode(int $1)";
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", (Object)decodeSig, (Object)decodeSrc);
        }
        iw.append((CharSequence)"@Override\n").append((CharSequence)decodeSig).append(' ').append((CharSequence)decodeSrc).append('\n');
        String encodeSrc = this.generateEnumEncodeMethodBody(petm);
        String encodeSig = "public int encode(" + petm.getJavaClassName() + " $1) throws IllegalArgumentException";
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", (Object)encodeSig, (Object)encodeSrc);
        }
        iw.append((CharSequence)"@Override\n").append((CharSequence)encodeSig).append(' ').append((CharSequence)encodeSrc);
        iw.dec();
        iw.append((CharSequence)"}\n");
        this.emitSource(fqn, iw.toString(), (ProtoTypeMetadata)petm);
    }

    private void addFileHeader(IndentWriter iw, String className) {
        iw.append((CharSequence)"/*\n");
        iw.append((CharSequence)" Generated by ").append((CharSequence)((Object)((Object)this)).getClass().getName()).append((CharSequence)"\n");
        iw.append((CharSequence)" for class ").append((CharSequence)className).append((CharSequence)"\n");
        iw.append((CharSequence)"*/\n\n");
    }

    private void generateMessageMarshaller(ProtoMessageTypeMetadata pmtm) throws IOException {
        String fqn;
        String marshallerClassName = this.makeUniqueMarshallerClassName((ProtoTypeMetadata)pmtm);
        if (log.isTraceEnabled()) {
            log.tracef("Generating message marshaller %s for %s", (Object)marshallerClassName, (Object)pmtm.getJavaClass().getName());
        }
        IndentWriter iw = new IndentWriter();
        this.addFileHeader(iw, pmtm.getAnnotatedClassName());
        if (pmtm.getAnnotatedClass().getPackageName() != null) {
            fqn = pmtm.getAnnotatedClass().getPackageName() + '.' + marshallerClassName;
            iw.append((CharSequence)"package ").append((CharSequence)pmtm.getAnnotatedClass().getPackageName()).append((CharSequence)";\n\n");
        } else {
            fqn = marshallerClassName;
        }
        if (pmtm.getJavaClass().getPackageName() != null) {
            iw.append((CharSequence)"import ").append((CharSequence)pmtm.getJavaClassName()).append((CharSequence)";\n\n");
        }
        AutoProtoSchemaBuilderAnnotationProcessor.addGeneratedClassHeader(iw, true, new String[0]);
        iw.append((CharSequence)"@SuppressWarnings(\"all\")\n");
        iw.append((CharSequence)"public final class ").append((CharSequence)marshallerClassName).append((CharSequence)" extends ").append((CharSequence)GeneratedMarshallerBase.class.getName()).append((CharSequence)" implements ").append((CharSequence)RawProtobufMarshaller.class.getName()).append('<').append((CharSequence)pmtm.getJavaClassName()).append('>').append((CharSequence)" {\n\n");
        iw.inc();
        if (pmtm.isBridge()) {
            this.addBridgeField(iw, pmtm);
        }
        this.addMarshallerDelegateFields(iw, pmtm);
        iw.append((CharSequence)"@Override\npublic Class<").append((CharSequence)pmtm.getJavaClassName()).append((CharSequence)"> getJavaClass() { return ").append((CharSequence)pmtm.getJavaClassName()).append((CharSequence)".class; }\n\n");
        iw.append((CharSequence)"@Override\npublic String getTypeName() { return \"").append((CharSequence)this.makeQualifiedTypeName(pmtm.getFullName())).append((CharSequence)"\"; }\n\n");
        String readFromSrc = this.generateReadFromMethodBody(pmtm);
        String readFromSig = "public " + pmtm.getJavaClassName() + " readFrom(" + ImmutableSerializationContext.class.getName() + " $1, " + RawProtoStreamReader.class.getName() + " $2) throws java.io.IOException";
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", (Object)readFromSig, (Object)readFromSrc);
        }
        iw.append((CharSequence)"@Override\n").append((CharSequence)readFromSig).append(' ').append((CharSequence)readFromSrc).append('\n');
        String writeToSrc = this.generateWriteToMethodBody(pmtm);
        String writeToSig = "public void writeTo(" + ImmutableSerializationContext.class.getName() + " $1, " + RawProtoStreamWriter.class.getName() + " $2, " + pmtm.getJavaClassName() + " $3) throws java.io.IOException";
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", (Object)writeToSig, (Object)writeToSrc);
        }
        iw.append((CharSequence)"@Override\n").append((CharSequence)writeToSig).append(' ').append((CharSequence)writeToSrc);
        iw.dec();
        iw.append((CharSequence)"}\n");
        this.emitSource(fqn, iw.toString(), (ProtoTypeMetadata)pmtm);
    }

    private void addBridgeField(IndentWriter iw, ProtoMessageTypeMetadata messageTypeMetadata) {
        iw.append((CharSequence)"private final ").append((CharSequence)messageTypeMetadata.getAnnotatedClassName()).append(' ').append((CharSequence)"__b$").append((CharSequence)" = new ").append((CharSequence)messageTypeMetadata.getAnnotatedClassName()).append((CharSequence)"();\n\n");
    }

    private void addMarshallerDelegateFields(IndentWriter iw, ProtoMessageTypeMetadata messageTypeMetadata) {
        HashSet<String> addedFields = new HashSet<String>();
        for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
            switch (fieldMetadata.getProtobufType()) {
                case GROUP: 
                case MESSAGE: 
                case ENUM: {
                    String fieldName = this.makeMarshallerDelegateFieldName(fieldMetadata);
                    if (!addedFields.add(fieldName)) break;
                    Class marshallerDelegateClass = fieldMetadata.getJavaType().isEnum() ? EnumMarshallerDelegate.class : BaseMarshallerDelegate.class;
                    iw.append((CharSequence)"private ").append((CharSequence)marshallerDelegateClass.getName()).append(' ').append((CharSequence)fieldName).append((CharSequence)";\n\n");
                }
            }
        }
    }

    private void emitSource(String fqn, String source, ProtoTypeMetadata ptm) throws IOException {
        this.generatedFilesWriter.addMarshallerSourceFile(fqn, source, ((HasModelElement)ptm.getJavaClass()).getElement());
        this.generatedClasses.add(fqn);
    }

    public Set<String> getGeneratedClasses() {
        return this.generatedClasses;
    }
}

