/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor;

import java.util.Map;
import java.util.Set;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.AbstractMarshallerCodeGenerator;
import org.infinispan.protostream.annotations.impl.BaseProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.ImportedProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.processor.AnnotatedClassScanner;
import org.infinispan.protostream.annotations.impl.processor.AnnotationBasedImportedProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.processor.GeneratedFilesWriter;
import org.infinispan.protostream.annotations.impl.processor.MarshallerSourceCodeGenerator;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XTypeFactory;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;

final class CompileTimeProtoSchemaGenerator
extends BaseProtoSchemaGenerator {
    private final Map<XClass, String> dependencies;
    private final MarshallerSourceCodeGenerator marshallerSourceCodeGenerator;
    private final AnnotatedClassScanner classScanner;

    CompileTimeProtoSchemaGenerator(XTypeFactory typeFactory, GeneratedFilesWriter generatedFilesWriter, SerializationContext serializationContext, String generator, String fileName, String packageName, Map<XClass, String> dependencies, Set<XClass> classes, boolean autoImportClasses, AnnotatedClassScanner classScanner) {
        super(typeFactory, serializationContext, generator, fileName, packageName, classes, autoImportClasses);
        this.dependencies = dependencies;
        this.marshallerSourceCodeGenerator = new MarshallerSourceCodeGenerator(generatedFilesWriter, typeFactory, packageName);
        this.classScanner = classScanner;
    }

    protected AbstractMarshallerCodeGenerator makeCodeGenerator() {
        return this.marshallerSourceCodeGenerator;
    }

    protected ProtoTypeMetadata importProtoTypeMetadata(XClass javaType) {
        if (javaType == this.typeFactory.fromClass(WrappedMessage.class)) {
            GenericDescriptor descriptor = this.serializationContext.getDescriptorByName("org.infinispan.protostream.WrappedMessage");
            BaseMarshaller marshaller = this.serializationContext.getMarshaller("org.infinispan.protostream.WrappedMessage");
            return new ImportedProtoTypeMetadata(descriptor, marshaller, javaType);
        }
        String fileName = this.dependencies.get(javaType);
        if (fileName != null) {
            String packageName = ((FileDescriptor)this.serializationContext.getFileDescriptors().get(fileName)).getPackage();
            return new AnnotationBasedImportedProtoTypeMetadata(this.makeProtoTypeMetadata(javaType), packageName, fileName);
        }
        return null;
    }

    protected boolean isUnknownClass(XClass c) {
        if (super.isUnknownClass(c) && !this.dependencies.containsKey(c) && !this.classScanner.isClassAcceptable(c)) {
            throw new ProtoSchemaBuilderException("Found a reference to class " + c.getCanonicalName() + " which was not explicitly included by @AutoProtoSchemaBuilder and the combination of relevant attributes (basePackages, includeClasses, excludeClasses, autoImportClasses) do not allow it to be included.");
        }
        return false;
    }

    public Set<String> getGeneratedMarshallerClasses() {
        return this.marshallerSourceCodeGenerator.getGeneratedClasses();
    }
}

