/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoEnum;
import org.infinispan.protostream.annotations.ProtoEnumValue;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoMessage;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.protostream.annotations.impl.processor.AnnotationProcessingException;

final class AnnotatedClassScanner {
    private TreeMap<String, TypeMirror> classes;
    private final Messager messager;
    private final Elements elements;
    private final Element builderElement;
    private final AutoProtoSchemaBuilder builderAnnotation;
    private final Set<String> basePackages;
    private final Set<TypeMirror> includedClasses;
    private final Set<TypeMirror> excludedClasses;
    private final PackageElement packageOfInitializer;

    AnnotatedClassScanner(Messager messager, Elements elements, Element builderElement, AutoProtoSchemaBuilder builderAnnotation) {
        this.messager = messager;
        this.elements = elements;
        this.builderElement = builderElement;
        this.builderAnnotation = builderAnnotation;
        this.includedClasses = this.getIncludedClasses();
        this.excludedClasses = this.getExcludedClasses();
        this.basePackages = this.getBasePackages();
        this.packageOfInitializer = elements.getPackageOf(builderElement);
    }

    Collection<? extends TypeMirror> getClasses() {
        return this.classes.values();
    }

    void discoverClasses(RoundEnvironment roundEnv) throws AnnotationProcessingException {
        this.classes = new TreeMap();
        if (this.includedClasses.isEmpty()) {
            TypeElement typeElement;
            Element enclosingElement;
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoField.class)) {
                enclosingElement = element.getEnclosingElement();
                if (enclosingElement.getKind() != ElementKind.CLASS && enclosingElement.getKind() != ElementKind.INTERFACE) continue;
                TypeElement typeElement2 = (TypeElement)enclosingElement;
                this.collectClasses(typeElement2);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoEnumValue.class)) {
                enclosingElement = element.getEnclosingElement();
                if (element.getKind() != ElementKind.ENUM_CONSTANT || enclosingElement.getKind() != ElementKind.ENUM) {
                    throw new AnnotationProcessingException(element, "@ProtoEnumValue can only be applied to enum constants.", new Object[0]);
                }
                TypeElement typeElement2 = (TypeElement)enclosingElement;
                this.collectClasses(typeElement2);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoEnum.class)) {
                if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE) {
                    throw new AnnotationProcessingException(element, "@ProtoEnum can only be applied to enums.", new Object[0]);
                }
                typeElement = (TypeElement)element;
                this.collectClasses(typeElement);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoMessage.class)) {
                if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE) {
                    throw new AnnotationProcessingException(element, "@ProtoMessage can only be applied to classes and interfaces.", new Object[0]);
                }
                typeElement = (TypeElement)element;
                this.collectClasses(typeElement);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoName.class)) {
                if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE && element.getKind() != ElementKind.ENUM) {
                    throw new AnnotationProcessingException(element, "@ProtoName can only be applied to classes, interfaces and enums.", new Object[0]);
                }
                typeElement = (TypeElement)element;
                this.collectClasses(typeElement);
            }
        } else {
            for (TypeMirror typeMirror : this.includedClasses) {
                TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
                this.collectClasses(typeElement);
            }
        }
    }

    boolean isIncluded(String classFQN) {
        TypeElement typeElement = this.elements.getTypeElement(classFQN);
        TypeMirror type = typeElement.asType();
        if (this.excludedClasses.contains(type)) {
            return false;
        }
        PackageElement packageOfElement = this.elements.getPackageOf(typeElement);
        if (!this.isPackageIncluded(packageOfElement)) {
            return false;
        }
        if (!this.includedClasses.isEmpty() && this.includedClasses.contains(type)) {
            return true;
        }
        return this.builderAnnotation.autoImportClasses() || this.includedClasses.isEmpty();
    }

    private Set<String> getBasePackages() {
        if (this.builderAnnotation.value().length == 0 && this.builderAnnotation.basePackages().length == 0) {
            return Collections.emptySet();
        }
        if (this.builderAnnotation.value().length != 0 && this.builderAnnotation.basePackages().length != 0) {
            throw new AnnotationProcessingException(this.builderElement, "@AutoProtoSchemaBuilder.value and @AutoProtoSchemaBuilder.basePackages are mutually exclusive", new Object[0]);
        }
        boolean usingAlias = true;
        String[] basePackages = this.builderAnnotation.value();
        if (basePackages.length == 0) {
            usingAlias = false;
            basePackages = this.builderAnnotation.basePackages();
        }
        HashSet<String> packages = new HashSet<String>(basePackages.length);
        for (String p : basePackages) {
            if (!SourceVersion.isName(p)) {
                throw new AnnotationProcessingException(this.builderElement, "@AutoProtoSchemaBuilder.%s contains an invalid package name : \"%s\"", usingAlias ? "value" : "basePackages", p);
            }
            packages.add(p);
        }
        return packages;
    }

    private Set<TypeMirror> getIncludedClasses() {
        List<Object> classes = Collections.emptyList();
        try {
            this.builderAnnotation.includeClasses();
        }
        catch (MirroredTypesException mte) {
            classes = mte.getTypeMirrors();
        }
        return new LinkedHashSet<TypeMirror>(classes);
    }

    private Set<TypeMirror> getExcludedClasses() {
        List<Object> classes = Collections.emptyList();
        try {
            this.builderAnnotation.excludeClasses();
        }
        catch (MirroredTypesException mte) {
            classes = mte.getTypeMirrors();
        }
        return new LinkedHashSet<TypeMirror>(classes);
    }

    private void collectClasses(TypeElement typeElement) {
        TypeMirror type = typeElement.asType();
        if (this.excludedClasses.contains(type)) {
            return;
        }
        PackageElement packageOfElement = this.elements.getPackageOf(typeElement);
        if (!this.isPackageIncluded(packageOfElement)) {
            return;
        }
        if (this.includedClasses.isEmpty()) {
            if (typeElement.getKind() == ElementKind.INTERFACE || typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                return;
            }
            if (packageOfElement.isUnnamed() && !this.packageOfInitializer.isUnnamed() || !packageOfElement.equals(this.packageOfInitializer) && !this.isPublicElement(typeElement)) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, String.format("Type %s is not visible to %s so it is ignored!", typeElement.getQualifiedName(), this.packageOfInitializer.getQualifiedName()), this.builderElement);
                return;
            }
        }
        this.classes.putIfAbsent(typeElement.getQualifiedName().toString(), type);
    }

    private boolean isPublicElement(TypeElement typeElement) {
        block2: {
            Element e = typeElement;
            do {
                if (!e.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    return false;
                }
                if ((e = e.getEnclosingElement()) == null || e.getKind() == ElementKind.PACKAGE) break block2;
            } while (e.getKind() == ElementKind.CLASS || e.getKind() == ElementKind.INTERFACE || e.getKind() == ElementKind.ENUM);
            return false;
        }
        return true;
    }

    private boolean isPackageIncluded(PackageElement packageElement) {
        if (this.basePackages.isEmpty()) {
            return true;
        }
        String p = packageElement.getQualifiedName().toString();
        while (true) {
            if (this.basePackages.contains(p)) {
                return true;
            }
            int pos = p.lastIndexOf(46);
            if (pos == -1) break;
            p = p.substring(0, pos);
        }
        return false;
    }
}

