/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor;

import java.util.Map;
import java.util.Set;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.impl.AbstractMarshallerCodeGenerator;
import org.infinispan.protostream.annotations.impl.BaseProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.processor.AnnotationBasedImportedProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.processor.GeneratedFilesWriter;
import org.infinispan.protostream.annotations.impl.processor.MarshallerSourceCodeGenerator;
import org.infinispan.protostream.annotations.impl.types.UnifiedTypeFactory;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.descriptors.FileDescriptor;

final class CompileTimeProtoSchemaGenerator
extends BaseProtoSchemaGenerator {
    private final Map<XClass, String> dependencies;
    private final MarshallerSourceCodeGenerator marshallerSourceCodeGenerator;

    CompileTimeProtoSchemaGenerator(UnifiedTypeFactory typeFactory, GeneratedFilesWriter generatedFilesWriter, SerializationContext serializationContext, String fileName, String packageName, Map<XClass, String> dependencies, Set<XClass> classes, boolean autoImportClasses) {
        super(typeFactory, serializationContext, fileName, packageName, classes, autoImportClasses);
        this.dependencies = dependencies;
        this.marshallerSourceCodeGenerator = new MarshallerSourceCodeGenerator(generatedFilesWriter, typeFactory, packageName);
    }

    protected AbstractMarshallerCodeGenerator makeCodeGenerator() {
        return this.marshallerSourceCodeGenerator;
    }

    protected ProtoTypeMetadata importProtoTypeMetadata(XClass javaType) {
        String fileName = this.dependencies.get(javaType);
        if (fileName != null) {
            String packageName = ((FileDescriptor)this.serializationContext.getFileDescriptors().get(fileName)).getPackage();
            return new AnnotationBasedImportedProtoTypeMetadata(this.makeProtoTypeMetadata(javaType), packageName, fileName);
        }
        return null;
    }

    protected boolean isUnknownClass(XClass c) {
        return !this.dependencies.containsKey(c) && super.isUnknownClass(c);
    }

    public Set<String> getGeneratedMarshallerClasses() {
        return this.marshallerSourceCodeGenerator.getGeneratedClasses();
    }
}

