/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.tool;

import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import org.infinispan.server.logging.Messages;

public abstract class Main {
    protected final PrintStream stdOut;
    protected final PrintStream stdErr;
    protected final Properties properties;
    protected final String cwd;
    protected File serverHome;
    protected File serverRoot;

    public Main() {
        this(System.out, System.err, System.getProperties());
    }

    public Main(PrintStream stdOut, PrintStream stdErr, Properties properties) {
        this.stdOut = stdOut;
        this.stdErr = stdErr;
        this.properties = properties;
        this.cwd = properties.getProperty("user.dir");
        this.serverHome = new File(properties.getProperty("infinispan.server.home.path", this.cwd));
        this.serverRoot = new File(properties.getProperty("infinispan.server.root.path", new File(this.serverHome, "server").getAbsolutePath()));
    }

    public final void run(String ... args) {
        Iterator<String> iterator = Arrays.stream(args).iterator();
        block14: while (iterator.hasNext()) {
            String command = (String)iterator.next();
            String parameter = null;
            if (command.startsWith("--")) {
                int equals = command.indexOf(61);
                if (equals > 0) {
                    parameter = command.substring(equals + 1);
                    command = command.substring(0, equals);
                }
            } else if (command.startsWith("-D")) {
                if (command.length() < 3) {
                    this.stdErr.println(Messages.MSG.invalidArgument(command));
                    this.exit(1);
                    return;
                }
                parameter = command.substring(2);
                command = command.substring(0, 2);
            } else if (command.startsWith("-")) {
                if (command.length() != 2) {
                    this.stdErr.println(Messages.MSG.invalidShortArgument(command));
                    this.exit(1);
                    return;
                }
            } else {
                this.stdErr.println(Messages.MSG.invalidArgument(command));
                this.exit(1);
                return;
            }
            switch (command) {
                case "-h": 
                case "--help": {
                    this.version(this.stdOut);
                    this.help(this.stdOut);
                    this.exit(0);
                    return;
                }
                case "-D": {
                    int equals = parameter.indexOf(61);
                    if (equals > 0) {
                        this.properties.setProperty(parameter.substring(0, equals), parameter.substring(equals + 1));
                        continue block14;
                    }
                    this.properties.setProperty(parameter, "");
                    continue block14;
                }
                case "-v": 
                case "--version": {
                    this.version(this.stdOut);
                    this.exit(0);
                    return;
                }
            }
            try {
                this.handleArgumentCommand(command, parameter, iterator);
            }
            catch (IllegalArgumentException e) {
                this.stdErr.println(Messages.MSG.unknownArgument(command));
                this.exit(1);
                return;
            }
        }
        this.runInternal();
    }

    protected abstract void runInternal();

    protected abstract void handleArgumentCommand(String var1, String var2, Iterator<String> var3);

    public void exit(int exitCode) {
        System.exit(exitCode);
    }

    public abstract void help(PrintStream var1);

    public abstract void version(PrintStream var1);
}

