/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.tasks;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.security.auth.Subject;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.Security;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.tasks.ServerTaskRunner;
import org.infinispan.server.tasks.ServerTaskWrapper;
import org.infinispan.tasks.TaskContext;
import org.infinispan.util.concurrent.BlockingManager;

public final class LocalServerTaskRunner
implements ServerTaskRunner {
    private static final LocalServerTaskRunner INSTANCE = new LocalServerTaskRunner();

    private LocalServerTaskRunner() {
    }

    public static LocalServerTaskRunner getInstance() {
        return INSTANCE;
    }

    @Override
    public <T> CompletableFuture<T> execute(ServerTaskWrapper<T> task, TaskContext context) {
        try {
            BlockingManager bm = (BlockingManager)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)context.getCacheManager()).getComponent(BlockingManager.class);
            return bm.supplyBlocking(() -> Security.doAs((Subject)context.subject(), (Function)task, (Object)context), (Object)("local-task-" + task.getName())).toCompletableFuture();
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }
}

