/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import io.netty.channel.Channel;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.core.security.sasl.SaslAuthenticator;
import org.infinispan.server.security.ElytronSASLAuthenticator;

public class RespClientCertAuthenticator {
    private final String realmName;
    private final ElytronSASLAuthenticator authenticator;

    public RespClientCertAuthenticator(String realmName) {
        this.realmName = realmName;
        this.authenticator = new ElytronSASLAuthenticator(realmName, null, Collections.singleton("EXTERNAL"));
    }

    public CompletionStage<Subject> clientCertAuth(Channel channel) throws SaslException {
        SaslServer server = null;
        try {
            server = SaslAuthenticator.createSaslServer((SaslAuthenticator)this.authenticator, null, (Channel)channel, (String)"EXTERNAL", (String)"resp");
            if (server == null) {
                CompletableFuture completableFuture = CompletableFutures.completedNull();
                return completableFuture;
            }
            server.evaluateResponse(Util.EMPTY_BYTE_ARRAY);
            CompletableFuture<Subject> completableFuture = CompletableFuture.completedFuture((Subject)server.getNegotiatedProperty("org.infinispan.security.Subject"));
            return completableFuture;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            if (server != null) {
                server.dispose();
            }
        }
    }

    public void init(ServerConfiguration configuration, ScheduledExecutorService timeoutExecutor) {
        this.authenticator.init(configuration, timeoutExecutor);
    }
}

