/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Principal;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;
import javax.net.ssl.SSLContext;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.io.FileWatcher;
import org.infinispan.commons.io.StringBuilderWriter;
import org.infinispan.commons.jdkspecific.ProcessInfo;
import org.infinispan.commons.time.DefaultTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.OS;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.annotations.Proto;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.jgroups.NamedSocketFactory;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.authentication.RestAuthenticator;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.security.AuditLogger;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.GlobalSecurityManager;
import org.infinispan.security.Security;
import org.infinispan.security.audit.LoggingAuditLogger;
import org.infinispan.security.impl.Authorizer;
import org.infinispan.server.DefaultExitHandler;
import org.infinispan.server.ExitHandler;
import org.infinispan.server.ExitStatus;
import org.infinispan.server.Extensions;
import org.infinispan.server.SecurityActions;
import org.infinispan.server.configuration.DataSourceConfiguration;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.ServerConfigurationSerializer;
import org.infinispan.server.configuration.endpoint.EndpointConfiguration;
import org.infinispan.server.configuration.endpoint.EndpointConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.configuration.security.RealmsConfiguration;
import org.infinispan.server.configuration.security.ServerTransportConfiguration;
import org.infinispan.server.configuration.security.TokenRealmConfiguration;
import org.infinispan.server.context.ServerInitialContextFactoryBuilder;
import org.infinispan.server.core.BackupManager;
import org.infinispan.server.core.BaseServerManagement;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.ServerManagement;
import org.infinispan.server.core.ServerStateManager;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.backup.BackupManagerImpl;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.datasource.DataSourceFactory;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.logging.Log;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.configuration.MemcachedAuthenticationConfiguration;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.configuration.RespServerConfiguration;
import org.infinispan.server.router.RoutingTable;
import org.infinispan.server.router.configuration.SinglePortRouterConfiguration;
import org.infinispan.server.router.router.impl.singleport.SinglePortEndpointRouter;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.RouteSource;
import org.infinispan.server.router.routes.hotrod.HotRodServerRouteDestination;
import org.infinispan.server.router.routes.memcached.MemcachedServerRouteDestination;
import org.infinispan.server.router.routes.resp.RespServerRouteDestination;
import org.infinispan.server.router.routes.rest.RestServerRouteDestination;
import org.infinispan.server.router.routes.singleport.SinglePortRouteSource;
import org.infinispan.server.security.ElytronHTTPAuthenticator;
import org.infinispan.server.security.ElytronJMXAuthenticator;
import org.infinispan.server.security.ElytronSASLAuthenticator;
import org.infinispan.server.security.ElytronUsernamePasswordAuthenticator;
import org.infinispan.server.security.ServerSecurityRealm;
import org.infinispan.server.state.ServerStateManagerImpl;
import org.infinispan.server.tasks.admin.ServerAdminOperationsHandler;
import org.infinispan.tasks.manager.TaskManager;
import org.infinispan.telemetry.InfinispanTelemetry;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.function.SerializableFunction;
import org.infinispan.util.logging.LogFactory;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableRealmIdentityIterator;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.http.basic.WildFlyElytronHttpBasicProvider;
import org.wildfly.security.http.bearer.WildFlyElytronHttpBearerProvider;
import org.wildfly.security.http.cert.WildFlyElytronHttpClientCertProvider;
import org.wildfly.security.http.digest.WildFlyElytronHttpDigestProvider;
import org.wildfly.security.http.spnego.WildFlyElytronHttpSpnegoProvider;
import org.wildfly.security.sasl.digest.WildFlyElytronSaslDigestProvider;
import org.wildfly.security.sasl.external.WildFlyElytronSaslExternalProvider;
import org.wildfly.security.sasl.gs2.WildFlyElytronSaslGs2Provider;
import org.wildfly.security.sasl.gssapi.WildFlyElytronSaslGssapiProvider;
import org.wildfly.security.sasl.localuser.WildFlyElytronSaslLocalUserProvider;
import org.wildfly.security.sasl.oauth2.WildFlyElytronSaslOAuth2Provider;
import org.wildfly.security.sasl.plain.WildFlyElytronSaslPlainProvider;
import org.wildfly.security.sasl.scram.WildFlyElytronSaslScramProvider;

public class Server
extends BaseServerManagement
implements AutoCloseable {
    public static final Log log = (Log)LogFactory.getLog((String)"SERVER", Log.class);
    public static final String INFINISPAN_BIND_ADDRESS = "infinispan.bind.address";
    public static final String INFINISPAN_BIND_PORT = "infinispan.bind.port";
    public static final String INFINISPAN_CLUSTER_NAME = "infinispan.cluster.name";
    public static final String INFINISPAN_CLUSTER_STACK = "infinispan.cluster.stack";
    public static final String INFINISPAN_NODE_NAME = "infinispan.node.name";
    public static final String INFINISPAN_PORT_OFFSET = "infinispan.socket.binding.port-offset";
    public static final String JGROUPS_BIND_ADDRESS = "jgroups.bind.address";
    public static final String JGROUPS_BIND_PORT = "jgroups.bind.port";
    public static final String JGROUPS_FD_PORT_OFFSET = "jgroups.fd.port-offset";
    public static final String INFINISPAN_SERVER_HOME_PATH = "infinispan.server.home.path";
    public static final String INFINISPAN_SERVER_ROOT_PATH = "infinispan.server.root.path";
    public static final String INFINISPAN_SERVER_CONFIG_PATH = "infinispan.server.config.path";
    public static final String INFINISPAN_SERVER_DATA_PATH = "infinispan.server.data.path";
    public static final String INFINISPAN_SERVER_LOG_PATH = "infinispan.server.log.path";
    public static final String INFINISPAN_LOG4J_SHUTDOWN = "infinispan.server.log4j.shutdown";
    public static final String INFINISPAN_ELYTRON_NONCE_SHUTDOWN = "infinispan.security.elytron.nonceshutdown";
    public static final String INFINISPAN_FILE_WATCHER = "infinispan.file.watcher";
    private static final String SERVER_DEFAULTS = "infinispan-server-templates.xml";
    public static final String DEFAULT_SERVER_CONFIG = "conf";
    public static final String DEFAULT_SERVER_DATA = "data";
    public static final String DEFAULT_SERVER_LIB = "lib";
    public static final String DEFAULT_SERVER_LOG = "log";
    public static final String DEFAULT_SERVER_ROOT_DIR = "server";
    public static final String DEFAULT_SERVER_STATIC_DIR = "static";
    public static final String DEFAULT_CONFIGURATION_FILE = "infinispan.xml";
    public static final String DEFAULT_LOGGING_FILE = "log4j2.xml";
    public static final String DEFAULT_CLUSTER_NAME = "cluster";
    public static final String DEFAULT_CLUSTER_STACK = "tcp";
    public static final int DEFAULT_BIND_PORT = 11222;
    public static final int DEFAULT_JGROUPS_BIND_PORT = 7800;
    public static final int DEFAULT_JGROUPS_FD_PORT_OFFSET = 50000;
    private static final int SHUTDOWN_DELAY_SECONDS = 3;
    private final ClassLoader classLoader;
    private final TimeService timeService;
    private final File serverHome;
    private final File serverRoot;
    private final File serverConf;
    private final Properties properties;
    private final LoggingAuditLogger defaultAuditLogger = new LoggingAuditLogger();
    private final CompletableFuture<Void> cacheManagerStart = new CompletableFuture();
    private ExitHandler exitHandler = new DefaultExitHandler();
    private ConfigurationBuilderHolder configurationBuilderHolder;
    private DefaultCacheManager cacheManager;
    private Map<String, ProtocolServer> protocolServers;
    private volatile ComponentStatus status;
    private ServerConfiguration serverConfiguration;
    private Extensions extensions;
    private ServerStateManager serverStateManager;
    private ScheduledExecutorService scheduler;
    private TaskManager taskManager;
    private ServerInitialContextFactoryBuilder initialContextFactoryBuilder;
    private BlockingManager blockingManager;
    private BackupManager backupManager;
    private Map<String, DataSource> dataSources;
    private final Path dataPath;
    private final FileWatcher watcher;

    public Server() {
        this(new File(DEFAULT_SERVER_ROOT_DIR), new File(DEFAULT_CONFIGURATION_FILE), System.getProperties());
    }

    public Server(File serverRoot, List<Path> configurationFiles, Properties properties) {
        this(serverRoot, properties);
        this.parseConfiguration(configurationFiles);
    }

    public Server(File serverRoot, File configuration, Properties properties) {
        this(serverRoot, Collections.singletonList(configuration.toPath()), properties);
    }

    private Server(File serverRoot, Properties properties) {
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.timeService = DefaultTimeService.INSTANCE;
        this.serverHome = new File(properties.getProperty(INFINISPAN_SERVER_HOME_PATH, ""));
        this.serverRoot = serverRoot;
        this.properties = properties;
        this.status = ComponentStatus.INSTANTIATED;
        properties.putIfAbsent(INFINISPAN_SERVER_HOME_PATH, this.serverHome.getAbsolutePath());
        properties.putIfAbsent(INFINISPAN_SERVER_ROOT_PATH, serverRoot.getAbsolutePath());
        properties.putIfAbsent(INFINISPAN_SERVER_CONFIG_PATH, new File(serverRoot, DEFAULT_SERVER_CONFIG).getAbsolutePath());
        properties.putIfAbsent(INFINISPAN_SERVER_DATA_PATH, new File(serverRoot, DEFAULT_SERVER_DATA).getAbsolutePath());
        properties.putIfAbsent(INFINISPAN_SERVER_LOG_PATH, new File(serverRoot, DEFAULT_SERVER_LOG).getAbsolutePath());
        this.dataPath = Paths.get(properties.getProperty(INFINISPAN_SERVER_DATA_PATH), new String[0]);
        this.serverConf = new File(properties.getProperty(INFINISPAN_SERVER_CONFIG_PATH));
        this.watcher = new FileWatcher();
        properties.put(INFINISPAN_FILE_WATCHER, this.watcher);
        this.registerInitialContextFactoryBuilder();
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronHttpBasicProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronHttpBearerProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronHttpDigestProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronHttpClientCertProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronHttpSpnegoProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslPlainProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslDigestProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslScramProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslExternalProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslLocalUserProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslOAuth2Provider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslGssapiProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslGs2Provider.getInstance());
    }

    private void registerInitialContextFactoryBuilder() {
        try {
            if (!NamingManager.hasInitialContextFactoryBuilder()) {
                this.initialContextFactoryBuilder = new ServerInitialContextFactoryBuilder();
                SecurityActions.setInitialContextFactoryBuilder(this.initialContextFactoryBuilder);
            } else {
                log.warn("Could not register the ServerInitialContextFactoryBuilder. JNDI will not be available");
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    private void parseConfiguration(List<Path> configurationFiles) {
        ParserRegistry parser = new ParserRegistry(this.classLoader, false, this.properties);
        try {
            ServerConfigurationBuilder serverBuilder;
            ServerTransportConfiguration serverTransportConfiguration;
            this.configurationBuilderHolder = new ConfigurationBuilderHolder(this.classLoader);
            GlobalConfigurationBuilder global = this.configurationBuilderHolder.getGlobalConfigurationBuilder();
            global.shutdown().hookBehavior(ShutdownHookBehavior.DONT_REGISTER).globalState().enable().persistentLocation(this.properties.getProperty(INFINISPAN_SERVER_DATA_PATH)).sharedPersistentLocation(this.properties.getProperty(INFINISPAN_SERVER_DATA_PATH)).configurationStorage(ConfigurationStorage.OVERLAY).security().authorization().auditLogger((AuditLogger)this.defaultAuditLogger);
            URL defaults = this.getClass().getClassLoader().getResource(SERVER_DEFAULTS);
            this.configurationBuilderHolder.read(parser.parse(defaults));
            for (Path configurationFile : configurationFiles) {
                if (!configurationFile.isAbsolute()) {
                    configurationFile = this.serverConf.toPath().resolve(configurationFile);
                }
                parser.parse(configurationFile.toUri().toURL(), this.configurationBuilderHolder);
            }
            if (log.isDebugEnabled()) {
                StringBuilderWriter sw = new StringBuilderWriter();
                try (ConfigurationWriter w = ConfigurationWriter.to((Writer)sw).prettyPrint(true).build();){
                    Map<String, Configuration> configs = this.configurationBuilderHolder.getNamedConfigurationBuilders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ConfigurationBuilder)e.getValue()).build()));
                    parser.serialize(w, global.build(), configs);
                }
                log.debugf("Actual configuration: %s", sw);
            }
            if ((serverTransportConfiguration = (serverBuilder = (ServerConfigurationBuilder)global.module(ServerConfigurationBuilder.class)).transport().create()).securityRealm() != null) {
                String securityRealm = serverTransportConfiguration.securityRealm();
                Supplier<SSLContext> serverSSLContextSupplier = serverBuilder.serverSSLContextSupplier(securityRealm);
                Supplier<SSLContext> clientSSLContextSupplier = serverBuilder.clientSSLContextSupplier(securityRealm);
                NamedSocketFactory namedSocketFactory = new NamedSocketFactory(() -> ((SSLContext)clientSSLContextSupplier.get()).getSocketFactory(), () -> ((SSLContext)serverSSLContextSupplier.get()).getServerSocketFactory());
                global.transport().addProperty("socketFactory", (Object)namedSocketFactory);
                log.sslTransport(securityRealm);
            }
            if (serverTransportConfiguration.dataSource() != null) {
                String dataSource = serverTransportConfiguration.dataSource();
                Supplier<DataSource> dataSourceSupplier = () -> this.dataSources.get(dataSource);
                global.transport().addProperty("dataSource", dataSourceSupplier);
            }
            ServerAdminOperationsHandler adminOperationsHandler = new ServerAdminOperationsHandler();
            ServerConfigurationBuilder serverConfigurationBuilder = (ServerConfigurationBuilder)global.module(ServerConfigurationBuilder.class);
            for (EndpointConfigurationBuilder endpoint : serverConfigurationBuilder.endpoints().endpoints().values()) {
                for (ProtocolServerConfigurationBuilder<?, ?, ?> connector : endpoint.connectors()) {
                    connector.adminOperationsHandler((AdminOperationsHandler)adminOperationsHandler);
                }
            }
            this.configurationBuilderHolder.validate();
        }
        catch (IOException e2) {
            throw new CacheConfigurationException((Exception)e2);
        }
    }

    public ExitHandler getExitHandler() {
        return this.exitHandler;
    }

    public void setExitHandler(ExitHandler exitHandler) {
        if (this.status != ComponentStatus.INSTANTIATED) {
            throw new IllegalStateException("Cannot change exit handler on a running server");
        }
        this.exitHandler = exitHandler;
    }

    public synchronized CompletableFuture<ExitStatus> run() {
        CompletableFuture<ExitStatus> r = this.exitHandler.getExitFuture();
        if (this.status == ComponentStatus.RUNNING) {
            return r;
        }
        CompletionStage exit = r.handle((status, t) -> {
            if (t != null) {
                log.serverFailedToStart(Version.getBrandName(), (Throwable)t);
            }
            this.localShutdown((ExitStatus)status);
            return null;
        });
        this.protocolServers = new ConcurrentHashMap<String, ProtocolServer>(4);
        try {
            this.extensions = new Extensions();
            this.extensions.load(this.classLoader);
            this.cacheManager = new DefaultCacheManager(this.configurationBuilderHolder, false);
            this.serverConfiguration = (ServerConfiguration)SecurityActions.getCacheManagerConfiguration((EmbeddedCacheManager)this.cacheManager).module(ServerConfiguration.class);
            this.serverConfiguration.setServer(this);
            this.dataSources = new HashMap<String, DataSource>();
            InitialContext initialContext = new InitialContext();
            for (DataSourceConfiguration dataSourceConfiguration : this.serverConfiguration.dataSources().values()) {
                DataSource dataSource = DataSourceFactory.create(dataSourceConfiguration);
                this.dataSources.put(dataSourceConfiguration.name(), dataSource);
                initialContext.bind(dataSourceConfiguration.jndiName(), (Object)dataSource);
            }
            GlobalComponentRegistry gcr = SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)this.cacheManager);
            gcr.registerComponent((Object)this, ServerManagement.class);
            if (gcr.getGlobalConfiguration().tracing().security()) {
                this.defaultAuditLogger.setTelemetryService((InfinispanTelemetry)gcr.getComponent(InfinispanTelemetry.class));
            }
            this.serverStateManager = new ServerStateManagerImpl(this, (EmbeddedCacheManager)this.cacheManager);
            gcr.registerComponent((Object)this.serverStateManager, ServerStateManager.class);
            this.blockingManager = (BlockingManager)gcr.getComponent(BlockingManager.class);
            ScheduledExecutorService timeoutExecutor = (ScheduledExecutorService)gcr.getComponent(ScheduledExecutorService.class, "org.infinispan.executors.timeout");
            this.backupManager = new BackupManagerImpl(this.blockingManager, this.cacheManager, this.dataPath);
            this.startCacheManager(this.blockingManager);
            this.taskManager = (TaskManager)gcr.getComponent(TaskManager.class);
            this.taskManager.registerTaskEngine(this.extensions.getServerTaskEngine((EmbeddedCacheManager)this.cacheManager));
            ElytronJMXAuthenticator.init((Authorizer)gcr.getComponent(Authorizer.class), this.serverConfiguration);
            for (EndpointConfiguration endpoint : this.serverConfiguration.endpoints().endpoints()) {
                SinglePortRouteSource routeSource = new SinglePortRouteSource();
                ConcurrentHashMap.KeySetView routes = ConcurrentHashMap.newKeySet();
                endpoint.connectors().parallelStream().forEach(configuration -> {
                    try {
                        Class<ProtocolServer> protocolServerClass = configuration.getClass().getAnnotation(ConfigurationFor.class).value().asSubclass(ProtocolServer.class);
                        ProtocolServer protocolServer = (ProtocolServer)Util.getInstance(protocolServerClass);
                        protocolServer.setServerManagement((ServerManagement)this, endpoint.admin());
                        if (configuration instanceof HotRodServerConfiguration) {
                            ElytronSASLAuthenticator.init((HotRodServerConfiguration)configuration, this.serverConfiguration, timeoutExecutor);
                        } else if (configuration instanceof RestServerConfiguration) {
                            ElytronHTTPAuthenticator.init((RestServerConfiguration)configuration, this.serverConfiguration);
                        } else if (configuration instanceof RespServerConfiguration) {
                            ElytronSASLAuthenticator.init((RespServerConfiguration)configuration, this.serverConfiguration, timeoutExecutor);
                            ElytronUsernamePasswordAuthenticator.init((RespServerConfiguration)configuration, this.serverConfiguration, this.blockingManager);
                        } else if (configuration instanceof MemcachedServerConfiguration) {
                            ElytronSASLAuthenticator.init((MemcachedServerConfiguration)configuration, this.serverConfiguration, timeoutExecutor);
                            ElytronUsernamePasswordAuthenticator.init(((MemcachedAuthenticationConfiguration)((MemcachedServerConfiguration)configuration).authentication()).text().authenticator(), this.serverConfiguration, this.blockingManager);
                        }
                        this.protocolServers.put(protocolServer.getName() + "-" + configuration.name(), protocolServer);
                        SecurityActions.startProtocolServer((ProtocolServer<ProtocolServerConfiguration>)protocolServer, configuration, (EmbeddedCacheManager)this.cacheManager);
                        ProtocolServerConfiguration protocolConfig = protocolServer.getConfiguration();
                        if (protocolConfig.startTransport()) {
                            log.protocolStarted(protocolServer);
                        } else {
                            if (protocolServer instanceof HotRodServer) {
                                routes.add(new Route((RouteSource)routeSource, (RouteDestination)new HotRodServerRouteDestination(protocolServer.getName(), (HotRodServer)protocolServer)));
                                this.extensions.apply((HotRodServer)protocolServer);
                            } else if (protocolServer instanceof RestServer) {
                                routes.add(new Route((RouteSource)routeSource, (RouteDestination)new RestServerRouteDestination(protocolServer.getName(), (RestServer)protocolServer)));
                            } else if (protocolServer instanceof RespServer) {
                                routes.add(new Route((RouteSource)routeSource, (RouteDestination)new RespServerRouteDestination(protocolServer.getName(), (RespServer)protocolServer)));
                            } else if (protocolServer instanceof MemcachedServer) {
                                routes.add(new Route((RouteSource)routeSource, (RouteDestination)new MemcachedServerRouteDestination(protocolServer.getName(), (MemcachedServer)protocolServer)));
                            }
                            log.protocolStarted(protocolServer);
                        }
                    }
                    catch (Throwable t) {
                        throw t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
                    }
                });
                SinglePortRouterConfiguration singlePortRouter = endpoint.singlePortRouter();
                SinglePortEndpointRouter endpointServer = new SinglePortEndpointRouter(singlePortRouter);
                endpointServer.start(new RoutingTable(routes), (EmbeddedCacheManager)this.cacheManager);
                this.protocolServers.put("endpoint-" + endpoint.socketBinding(), (ProtocolServer)endpointServer);
                log.protocolStarted((ProtocolServer<?>)endpointServer);
                log.endpointUrl(Objects.requireNonNullElse(this.cacheManager.getAddress(), "local"), singlePortRouter.ssl().enabled() ? "https" : "http", singlePortRouter.host(), singlePortRouter.port());
            }
            this.cacheManagerStart.whenComplete((ignore, t) -> {
                if (t != null) {
                    r.completeExceptionally((Throwable)t);
                    return;
                }
                this.serverStateManager.start();
                try {
                    this.backupManager.init();
                }
                catch (IOException e) {
                    throw CompletableFutures.asCompletionException((Throwable)e);
                }
                SecurityActions.postStartProtocolServer(this.protocolServers.values());
                log.serverStarted(Version.getBrandName(), Version.getBrandVersion(), this.uptime());
                this.status = ComponentStatus.RUNNING;
                if (Boolean.getBoolean("infinispan.shutdown.immediately")) {
                    r.complete(ExitStatus.SERVER_SHUTDOWN);
                }
            });
        }
        catch (Exception e) {
            r.completeExceptionally(e);
        }
        return exit;
    }

    private long uptime() {
        return ManagementFactory.getRuntimeMXBean().getUptime();
    }

    public void serializeConfiguration(ConfigurationWriter writer) {
        writer.writeStartDocument();
        ServerConfigurationSerializer serializer = new ServerConfigurationSerializer();
        serializer.serialize(writer, this.serverConfiguration);
        writer.writeEndDocument();
    }

    private void startCacheManager(BlockingManager bm) {
        bm.runBlocking(() -> {
            try {
                SecurityActions.startCacheManager((EmbeddedCacheManager)this.cacheManager);
                this.cacheManagerStart.complete(null);
            }
            catch (Throwable t) {
                this.cacheManagerStart.completeExceptionally(t);
            }
        }, (Object)"start-cm");
    }

    public CompletionStage<Void> cacheManagerStart() {
        return this.cacheManagerStart;
    }

    public Map<String, String> getLoginConfiguration(ProtocolServer protocolServer) {
        HashMap<String, String> loginConfiguration = new HashMap<String, String>();
        RestServerConfiguration rest = (RestServerConfiguration)protocolServer.getConfiguration();
        if (rest.authentication().mechanisms().contains("BEARER_TOKEN")) {
            RealmConfiguration realm = this.serverConfiguration.security().realms().getRealm(rest.authentication().securityRealm());
            TokenRealmConfiguration realmConfiguration = realm.realmProviders().stream().filter(r -> r instanceof TokenRealmConfiguration).map(r -> (TokenRealmConfiguration)r).findFirst().get();
            loginConfiguration.put("mode", "OIDC");
            loginConfiguration.put("url", realmConfiguration.authServerUrl());
            loginConfiguration.put("realm", realmConfiguration.name());
            loginConfiguration.put("clientId", realmConfiguration.clientId());
        } else {
            loginConfiguration.put("mode", "HTTP");
            for (String mechanism : rest.authentication().mechanisms()) {
                loginConfiguration.put(mechanism, "true");
            }
        }
        RestAuthenticator authenticator = rest.authentication().authenticator();
        loginConfiguration.put("ready", Boolean.toString(authenticator == null || authenticator.isReadyForHttpChallenge()));
        return loginConfiguration;
    }

    public void serverStop(List<String> servers) {
        SecurityActions.checkPermission(this.cacheManager.withSubject(Security.getSubject()), AuthorizationPermission.LIFECYCLE);
        ClusterExecutor executor = SecurityActions.getClusterExecutor((EmbeddedCacheManager)this.cacheManager);
        if (servers != null && !servers.isEmpty()) {
            List targets = this.cacheManager.getMembers().stream().filter(a -> servers.contains(a.toString())).collect(Collectors.toList());
            executor = executor.filterTargets(targets);
            this.sendExitStatusToServers(executor, ExitStatus.SERVER_SHUTDOWN);
        } else {
            this.serverStopHandler(ExitStatus.SERVER_SHUTDOWN);
        }
    }

    public void clusterStop() {
        SecurityActions.checkPermission(this.cacheManager.withSubject(Security.getSubject()), AuthorizationPermission.LIFECYCLE);
        this.cacheManager.getCacheNames().forEach(name -> SecurityActions.shutdownAllCaches(this.cacheManager));
        this.sendExitStatusToServers(SecurityActions.getClusterExecutor((EmbeddedCacheManager)this.cacheManager), ExitStatus.CLUSTER_SHUTDOWN);
    }

    public void containerStop() {
        SecurityActions.checkPermission(this.cacheManager.withSubject(Security.getSubject()), AuthorizationPermission.LIFECYCLE);
        this.status = ComponentStatus.STOPPING;
        SecurityActions.shutdownAllCaches(this.cacheManager);
    }

    private void sendExitStatusToServers(ClusterExecutor clusterExecutor, ExitStatus exitStatus) {
        CompletableFuture job = clusterExecutor.submitConsumer((SerializableFunction)new ShutdownRunnable(exitStatus), (a, i, t) -> {
            if (t != null) {
                log.clusteredTaskError((Throwable)t);
            }
        });
        job.join();
    }

    private void localShutdown(ExitStatus exitStatus) {
        this.status = ComponentStatus.STOPPING;
        if (exitStatus == ExitStatus.CLUSTER_SHUTDOWN) {
            log.clusterShutdown();
        }
        this.protocolServers.values().parallelStream().forEach(ProtocolServer::stop);
        SecurityActions.stopCacheManager((EmbeddedCacheManager)this.cacheManager);
        if (this.initialContextFactoryBuilder != null) {
            this.initialContextFactoryBuilder.close();
        }
        this.status = ComponentStatus.TERMINATED;
        this.close();
        this.shutdownLog4jLogManager();
    }

    private void shutdownLog4jLogManager() {
        if (Boolean.parseBoolean(this.properties.getProperty(INFINISPAN_LOG4J_SHUTDOWN, "true"))) {
            LogManager.shutdown();
        }
    }

    private void serverStopHandler(ExitStatus exitStatus) {
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.schedule(() -> this.getExitHandler().exit(exitStatus), 3L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        if (this.watcher != null) {
            this.watcher.stop();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    public DefaultCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public ServerStateManager getServerStateManager() {
        return this.serverStateManager;
    }

    public ConfigurationBuilderHolder getConfigurationBuilderHolder() {
        return this.configurationBuilderHolder;
    }

    public Map<String, ProtocolServer> getProtocolServers() {
        return this.protocolServers;
    }

    public ComponentStatus getStatus() {
        return this.status;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public Map<String, List<Principal>> getUsers() {
        HashMap<String, List<Principal>> map = new HashMap<String, List<Principal>>();
        RealmsConfiguration realms = this.serverConfiguration.security().realms();
        for (Map.Entry<String, RealmConfiguration> realm : realms.realms().entrySet()) {
            for (Map.Entry<String, SecurityRealm> subRealm : realm.getValue().realms().entrySet()) {
                SecurityRealm securityRealm = subRealm.getValue();
                if (!(securityRealm instanceof ModifiableSecurityRealm)) continue;
                ModifiableSecurityRealm msr = (ModifiableSecurityRealm)securityRealm;
                ArrayList<Principal> principals = new ArrayList<Principal>();
                try (ModifiableRealmIdentityIterator iterator = msr.getRealmIdentityIterator();){
                    while (iterator.hasNext()) {
                        principals.add(((ModifiableRealmIdentity)iterator.next()).getRealmIdentityPrincipal());
                    }
                }
                catch (RealmUnavailableException e) {
                    log.debugf(e, "Error while iterating identities on realm %s", subRealm.getKey());
                }
                if (principals.isEmpty()) continue;
                String name = realm.getKey() + ":" + subRealm.getKey();
                map.put(name, principals);
            }
        }
        return map;
    }

    public CompletionStage<Path> getServerReport() {
        SecurityActions.checkPermission(this.cacheManager.withSubject(Security.getSubject()), AuthorizationPermission.ADMIN);
        OS os = OS.getCurrentOs();
        String reportFile = "bin/%s";
        switch (os) {
            case LINUX: {
                reportFile = String.format(reportFile, "report.sh");
                break;
            }
            case MAC_OS: {
                reportFile = String.format(reportFile, "report-osx.sh");
                break;
            }
            default: {
                return CompletableFuture.failedFuture(log.serverReportUnavailable(os));
            }
        }
        long pid = ProcessInfo.getInstance().getPid();
        Path home = this.serverHome.toPath();
        Path root = this.serverRoot.toPath();
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command("sh", "-c", String.format("%s %s %s", home.resolve(reportFile), pid, root));
        return this.blockingManager.supplyBlocking(() -> {
            try {
                Process process = builder.start();
                if (!process.waitFor(1L, TimeUnit.MINUTES)) {
                    throw new IllegalStateException("Timed out waiting report process finish");
                }
                if (process.exitValue() != 0) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    String error = String.format("Report process failed. Exit code: '%d' Message: %s", process.exitValue(), reader.lines().collect(Collectors.joining("\n")));
                    throw new IllegalStateException(error);
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                return Paths.get(reader.readLine(), new String[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }, (Object)"report");
    }

    public BackupManager getBackupManager() {
        return this.backupManager;
    }

    public Map<String, DataSource> getDataSources() {
        return this.dataSources;
    }

    public Path getServerDataPath() {
        return this.dataPath;
    }

    public CompletionStage<Void> flushSecurityCaches() {
        return SecurityActions.getClusterExecutor((EmbeddedCacheManager)this.cacheManager).submitConsumer((SerializableFunction & Serializable)ecm -> {
            GlobalComponentRegistry gcr = SecurityActions.getGlobalComponentRegistry(ecm);
            ServerConfiguration serverConfiguration = (ServerConfiguration)SecurityActions.getCacheManagerConfiguration(ecm).module(ServerConfiguration.class);
            serverConfiguration.security().realms().flushRealmCaches();
            ((GlobalSecurityManager)gcr.getComponent(GlobalSecurityManager.class)).flushLocalACLCache();
            return null;
        }, (a, b, c) -> {}).thenApply(ignore -> null);
    }

    public Json securityOverviewReport() {
        Json result = Json.object();
        Json securityRealms = Json.object();
        for (Map.Entry<String, RealmConfiguration> realm : this.serverConfiguration.security().realms().realms().entrySet()) {
            Object realmConfig = realm.getValue();
            if (realmConfig.hasServerSSLContext()) {
                if (realmConfig.hasFeature(ServerSecurityRealm.Feature.TRUST)) {
                    securityRealms.set(realm.getKey(), Json.object((Object[])new Object[]{"tls", "CLIENT"}));
                    continue;
                }
                securityRealms.set(realm.getKey(), Json.object((Object[])new Object[]{"tls", "SERVER"}));
                continue;
            }
            securityRealms.set(realm.getKey(), Json.object((Object[])new Object[]{"tls", "NONE"}));
        }
        result.set("security-realms", securityRealms);
        List<EndpointConfiguration> endpoints = this.serverConfiguration.endpoints().endpoints();
        HashMap<String, String> realmsByEndpoints = new HashMap<String, String>(endpoints.size());
        for (EndpointConfiguration endpoint : endpoints) {
            realmsByEndpoints.put(endpoint.socketBinding(), endpoint.securityReam());
        }
        Json tlsEndpoints = Json.array();
        this.getProtocolServers().entrySet().stream().filter(e -> ((ProtocolServer)e.getValue()).getConfiguration().startTransport() && ((ProtocolServer)e.getValue()).getConfiguration().ssl().enabled()).map(psEntry -> {
            String socketBinding = ((ProtocolServer)psEntry.getValue()).getConfiguration().socketBinding();
            String realm = (String)realmsByEndpoints.get(socketBinding);
            return (String)psEntry.getKey() + "-" + realm;
        }).forEach(arg_0 -> ((Json)tlsEndpoints).add(arg_0));
        result.set("tls-endpoints", tlsEndpoints);
        return result;
    }

    @Proto
    @ProtoTypeId(value=6803)
    record ShutdownRunnable(ExitStatus exitStatus) implements SerializableFunction<EmbeddedCacheManager, Void>
    {
        public Void apply(EmbeddedCacheManager em) {
            Server server = ((ServerConfiguration)SecurityActions.getCacheManagerConfiguration(em).module(ServerConfiguration.class)).getServer();
            server.serverStopHandler(this.exitStatus);
            return null;
        }
    }
}

