/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.security.Principal;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import org.infinispan.security.GroupPrincipal;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.core.security.UsernamePasswordAuthenticator;
import org.infinispan.server.resp.authentication.RespAuthenticator;
import org.infinispan.server.resp.configuration.RespServerConfiguration;
import org.infinispan.server.security.ElytronRESPAuthenticator;
import org.infinispan.util.concurrent.BlockingManager;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

public class ElytronUsernamePasswordAuthenticator
implements UsernamePasswordAuthenticator {
    private final String name;
    private SecurityDomain securityDomain;
    private BlockingManager blockingManager;

    public ElytronUsernamePasswordAuthenticator(String name) {
        this.name = name;
    }

    public static void init(UsernamePasswordAuthenticator authenticator, ServerConfiguration serverConfiguration, BlockingManager blockingManager) {
        if (authenticator instanceof ElytronUsernamePasswordAuthenticator) {
            ((ElytronUsernamePasswordAuthenticator)authenticator).init(serverConfiguration, blockingManager);
        }
    }

    public static void init(RespServerConfiguration configuration, ServerConfiguration serverConfiguration, BlockingManager blockingManager) {
        RespAuthenticator authenticator = configuration.authentication().authenticator();
        if (authenticator != null) {
            ((ElytronRESPAuthenticator)authenticator).init(serverConfiguration, blockingManager);
        }
    }

    private void init(ServerConfiguration serverConfiguration, BlockingManager blockingManager) {
        this.securityDomain = serverConfiguration.security().realms().getRealm(this.name).serverSecurityRealm().getSecurityDomain();
        this.blockingManager = blockingManager;
    }

    public CompletionStage<Subject> authenticate(String username, char[] password) {
        return this.blockingManager.supplyBlocking(() -> {
            try {
                SecurityIdentity securityIdentity = this.securityDomain.authenticate(username, (Evidence)new PasswordGuessEvidence(password));
                Subject subject = new Subject();
                subject.getPrincipals().add(securityIdentity.getPrincipal());
                securityIdentity.getRoles().forEach(r -> subject.getPrincipals().add((Principal)new GroupPrincipal(r)));
                return subject;
            }
            catch (RealmUnavailableException e) {
                throw new RuntimeException(e);
            }
        }, (Object)"elytron-auth");
    }
}

