/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import java.util.Map;
import java.util.function.Supplier;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TimeQuantity;
import org.infinispan.server.configuration.DataSourceConfiguration;
import org.infinispan.server.security.PasswordCredentialSource;
import org.wildfly.security.credential.source.CredentialSource;

public class DataSourceConfigurationBuilder
implements Builder<DataSourceConfiguration> {
    private final AttributeSet attributes = DataSourceConfiguration.attributeDefinitionSet();

    DataSourceConfigurationBuilder(String name, String jndiName) {
        this.attributes.attribute(DataSourceConfiguration.NAME).set((Object)name);
        this.attributes.attribute(DataSourceConfiguration.JNDI_NAME).set((Object)jndiName);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public DataSourceConfiguration create() {
        return new DataSourceConfiguration(this.attributes.protect());
    }

    public DataSourceConfigurationBuilder read(DataSourceConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public DataSourceConfigurationBuilder driver(String driver) {
        this.attributes.attribute(DataSourceConfiguration.DRIVER).set((Object)driver);
        return this;
    }

    public DataSourceConfigurationBuilder username(String username) {
        this.attributes.attribute(DataSourceConfiguration.USERNAME).set((Object)username);
        return this;
    }

    public DataSourceConfigurationBuilder password(char[] password) {
        this.attributes.attribute(DataSourceConfiguration.PASSWORD).set((Object)new PasswordCredentialSource(password));
        return this;
    }

    public DataSourceConfigurationBuilder password(Supplier<CredentialSource> password) {
        this.attributes.attribute(DataSourceConfiguration.PASSWORD).set(password);
        return this;
    }

    public DataSourceConfigurationBuilder url(String url) {
        this.attributes.attribute(DataSourceConfiguration.URL).set((Object)url);
        return this;
    }

    public DataSourceConfigurationBuilder transactionIsolation(AgroalConnectionFactoryConfiguration.TransactionIsolation transactionIsolation) {
        this.attributes.attribute(DataSourceConfiguration.TRANSACTION_ISOLATION).set((Object)transactionIsolation);
        return this;
    }

    public DataSourceConfigurationBuilder newConnectionSql(String newConnectionSql) {
        this.attributes.attribute(DataSourceConfiguration.INITIAL_SQL).set((Object)newConnectionSql);
        return this;
    }

    public DataSourceConfigurationBuilder maxSize(int maxSize) {
        this.attributes.attribute(DataSourceConfiguration.MAX_SIZE).set((Object)maxSize);
        return this;
    }

    public DataSourceConfigurationBuilder minSize(int minSize) {
        this.attributes.attribute(DataSourceConfiguration.MIN_SIZE).set((Object)minSize);
        return this;
    }

    public DataSourceConfigurationBuilder initialSize(int initialSize) {
        this.attributes.attribute(DataSourceConfiguration.INITIAL_SIZE).set((Object)initialSize);
        return this;
    }

    public DataSourceConfigurationBuilder blockingTimeout(String blockingTimeout) {
        this.attributes.attribute(DataSourceConfiguration.BLOCKING_TIMEOUT).set((Object)TimeQuantity.valueOf((String)blockingTimeout));
        return this;
    }

    public DataSourceConfigurationBuilder backgroundValidation(String backgroundValidation) {
        this.attributes.attribute(DataSourceConfiguration.BACKGROUND_VALIDATION).set((Object)TimeQuantity.valueOf((String)backgroundValidation));
        return this;
    }

    public DataSourceConfigurationBuilder validateOnAcquisition(String validateOnAcquisition) {
        this.attributes.attribute(DataSourceConfiguration.VALIDATE_ON_ACQUISITION).set((Object)TimeQuantity.valueOf((String)validateOnAcquisition));
        return this;
    }

    public DataSourceConfigurationBuilder leakDetection(String leakDetection) {
        this.attributes.attribute(DataSourceConfiguration.LEAK_DETECTION).set((Object)TimeQuantity.valueOf((String)leakDetection));
        return this;
    }

    public DataSourceConfigurationBuilder idleRemoval(String idleRemoval) {
        this.attributes.attribute(DataSourceConfiguration.IDLE_REMOVAL).set((Object)TimeQuantity.valueOf((String)idleRemoval));
        return this;
    }

    public DataSourceConfigurationBuilder statistics(boolean enable) {
        this.attributes.attribute(DataSourceConfiguration.STATISTICS).set((Object)enable);
        return this;
    }

    public DataSourceConfigurationBuilder addProperty(String key, String value) {
        Attribute a = this.attributes.attribute(DataSourceConfiguration.CONNECTION_PROPERTIES);
        Map map = (Map)a.get();
        map.put(key, value);
        a.set((Object)map);
        return this;
    }
}

