/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.util.EnumSet;
import java.util.function.Supplier;
import org.infinispan.server.configuration.security.ServerIdentitiesConfiguration;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.credential.source.CredentialSource;

public class ServerSecurityRealm {
    private final String name;
    private final SecurityDomain securityDomain;
    private final Supplier<Boolean> httpChallengeReadiness;
    private final ServerIdentitiesConfiguration serverIdentities;
    private final EnumSet<Feature> features;

    public ServerSecurityRealm(String name, SecurityDomain securityDomain, Supplier<Boolean> httpChallengeReadiness, ServerIdentitiesConfiguration serverIdentities, EnumSet<Feature> features) {
        this.name = name;
        this.securityDomain = securityDomain;
        this.httpChallengeReadiness = httpChallengeReadiness;
        this.serverIdentities = serverIdentities;
        this.features = features;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadyForHttpChallenge() {
        return this.httpChallengeReadiness.get();
    }

    public SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    public void applyServerCredentials(MechanismConfiguration.Builder mechConfigurationBuilder, String serverPrincipal) {
        if (serverPrincipal != null) {
            CredentialSource credentialSource = this.serverIdentities.getCredentialSource(serverPrincipal);
            mechConfigurationBuilder.setServerCredentialSource(credentialSource);
        }
    }

    public ServerIdentitiesConfiguration getServerIdentities() {
        return this.serverIdentities;
    }

    public boolean hasFeature(Feature feature) {
        return this.features.contains((Object)feature);
    }

    public String toString() {
        return "ServerSecurityRealm{name='" + this.name + "', features=" + String.valueOf(this.features) + "}";
    }

    public static enum Feature {
        PASSWORD_PLAIN,
        PASSWORD_HASHED,
        TOKEN,
        TRUST,
        ENCRYPT;

    }
}

