/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.security.DistributedRealmConfiguration;
import org.infinispan.server.configuration.security.FileSystemRealmConfiguration;
import org.infinispan.server.configuration.security.RealmProviderBuilder;

public class FileSystemRealmConfigurationBuilder
implements RealmProviderBuilder<FileSystemRealmConfiguration> {
    private final AttributeSet attributes = FileSystemRealmConfiguration.attributeDefinitionSet();

    FileSystemRealmConfigurationBuilder() {
    }

    public FileSystemRealmConfigurationBuilder name(String name) {
        this.attributes.attribute(FileSystemRealmConfiguration.NAME).set((Object)name);
        return this;
    }

    @Override
    public String name() {
        return (String)this.attributes.attribute(DistributedRealmConfiguration.NAME).get();
    }

    public FileSystemRealmConfigurationBuilder path(String path) {
        this.attributes.attribute(FileSystemRealmConfiguration.PATH).set((Object)path);
        return this;
    }

    public FileSystemRealmConfigurationBuilder relativeTo(String relativeTo) {
        this.attributes.attribute(FileSystemRealmConfiguration.RELATIVE_TO).set((Object)relativeTo);
        return this;
    }

    public FileSystemRealmConfigurationBuilder levels(int levels) {
        this.attributes.attribute(FileSystemRealmConfiguration.LEVELS).set((Object)levels);
        return this;
    }

    public FileSystemRealmConfigurationBuilder encoded(boolean encoded) {
        this.attributes.attribute(FileSystemRealmConfiguration.ENCODED).set((Object)encoded);
        return this;
    }

    public FileSystemRealmConfiguration create() {
        return new FileSystemRealmConfiguration(this.attributes.protect());
    }

    public FileSystemRealmConfigurationBuilder read(FileSystemRealmConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    @Override
    public int compareTo(RealmProviderBuilder o) {
        return 0;
    }
}

