/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server;

import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.server.logging.events.PersistenceContextInitializerImpl;
import org.infinispan.server.logging.events.ServerEventLogger;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.util.logging.events.EventLogger;

@InfinispanModule(name="server-runtime", requiredModules={"core", "query-core"})
public class LifecycleCallbacks
implements ModuleLifecycle {
    private EventLogger oldEventLogger;

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration gc) {
        SerializationContextRegistry ctxRegistry = (SerializationContextRegistry)gcr.getComponent(SerializationContextRegistry.class);
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.PERSISTENCE, (SerializationContextInitializer)new PersistenceContextInitializerImpl());
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.PERSISTENCE, (SerializationContextInitializer)new org.infinispan.server.state.PersistenceContextInitializerImpl());
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)gcr.getComponent(EmbeddedCacheManager.class);
        InternalCacheRegistry internalCacheRegistry = (InternalCacheRegistry)gcr.getComponent(InternalCacheRegistry.class);
        internalCacheRegistry.registerInternalCache("___event_log_cache", this.getTaskHistoryCacheConfiguration(cacheManager).build(), EnumSet.of(InternalCacheRegistry.Flag.PERSISTENT, InternalCacheRegistry.Flag.QUERYABLE));
        this.oldEventLogger = ((EventLogManager)gcr.getComponent(EventLogManager.class)).replaceEventLogger((EventLogger)new ServerEventLogger(cacheManager, gcr.getTimeService()));
    }

    public void cacheStopping(ComponentRegistry cr, String cacheName) {
        if (cacheName.equals("___event_log_cache")) {
            ((EventLogManager)cr.getComponent(EventLogManager.class)).replaceEventLogger(this.oldEventLogger);
        }
    }

    private ConfigurationBuilder getTaskHistoryCacheConfiguration(EmbeddedCacheManager cacheManager) {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.memory().maxCount(100L).persistence().passivation(true).expiration().lifespan(7L, TimeUnit.DAYS);
        return cfg;
    }
}

