/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.SocketBindingConfiguration;
import org.infinispan.server.configuration.SocketBindingConfigurationBuilder;
import org.infinispan.server.configuration.SocketBindingsConfiguration;
import org.infinispan.server.network.SocketBinding;

public class SocketBindingsConfigurationBuilder
implements Builder<SocketBindingsConfiguration> {
    private final AttributeSet attributes;
    private final ServerConfigurationBuilder server;
    private Map<String, SocketBindingConfigurationBuilder> socketBindings = new LinkedHashMap<String, SocketBindingConfigurationBuilder>(2);

    SocketBindingsConfigurationBuilder(ServerConfigurationBuilder server) {
        this.server = server;
        this.attributes = SocketBindingsConfiguration.attributeDefinitionSet();
    }

    SocketBindingsConfigurationBuilder socketBinding(String name, int port, String interfaceName) {
        SocketBindingConfigurationBuilder configurationBuilder = new SocketBindingConfigurationBuilder(this.server);
        configurationBuilder.binding(name, port, interfaceName);
        this.socketBindings.put(name, configurationBuilder);
        return this;
    }

    public void validate() {
    }

    public Map<String, SocketBindingConfigurationBuilder> socketBindings() {
        return this.socketBindings;
    }

    public SocketBindingsConfigurationBuilder offset(Integer offset) {
        this.attributes.attribute(SocketBindingsConfiguration.PORT_OFFSET).set((Object)offset);
        return this;
    }

    public Integer offset() {
        return (Integer)this.attributes.attribute(SocketBindingsConfiguration.PORT_OFFSET).get();
    }

    SocketBindingsConfigurationBuilder defaultInterface(String interfaceName) {
        if (!this.server.interfaces().exists(interfaceName)) {
            throw Server.log.unknownInterface(interfaceName);
        }
        this.attributes.attribute(SocketBindingsConfiguration.DEFAULT_INTERFACE).set((Object)interfaceName);
        return this;
    }

    boolean exists(String bindingName) {
        return this.socketBindings.containsKey(bindingName);
    }

    public SocketBindingsConfiguration create() {
        List<SocketBindingConfiguration> bindings = this.socketBindings.values().stream().map(SocketBindingConfigurationBuilder::create).collect(Collectors.toList());
        return new SocketBindingsConfiguration(this.attributes.protect(), bindings);
    }

    public SocketBindingsConfigurationBuilder read(SocketBindingsConfiguration template) {
        this.attributes.read(template.attributes());
        this.socketBindings.clear();
        template.socketBindings().forEach(s -> this.socketBinding(s.name(), s.port(), s.interfaceName()));
        return this;
    }

    SocketBinding getSocketBinding(String name) {
        return this.socketBindings.get(name).getSocketBinding();
    }

    String defaultInterface() {
        return (String)this.attributes.attribute(SocketBindingsConfiguration.DEFAULT_INTERFACE).get();
    }
}

