/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.endpoint;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.endpoint.EndpointsConfiguration;
import org.infinispan.server.configuration.endpoint.SinglePortServerConfigurationBuilder;
import org.infinispan.server.configuration.security.KerberosSecurityFactoryConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.security.ServerSecurityRealm;

public class EndpointsConfigurationBuilder
implements Builder<EndpointsConfiguration> {
    private final AttributeSet attributes;
    private final ServerConfigurationBuilder serverConfigurationBuilder;
    private final List<ProtocolServerConfigurationBuilder<?, ?>> connectorBuilders = new ArrayList(2);
    private final SinglePortServerConfigurationBuilder singlePortBuilder = new SinglePortServerConfigurationBuilder();

    public EndpointsConfigurationBuilder(ServerConfigurationBuilder serverConfigurationBuilder) {
        this.serverConfigurationBuilder = serverConfigurationBuilder;
        this.attributes = EndpointsConfiguration.attributeDefinitionSet();
    }

    public EndpointsConfigurationBuilder socketBinding(String name) {
        this.attributes.attribute(EndpointsConfiguration.SOCKET_BINDING).set((Object)name);
        this.serverConfigurationBuilder.applySocketBinding(name, this.singlePortBuilder);
        return this;
    }

    public EndpointsConfigurationBuilder securityRealm(String name) {
        this.attributes.attribute(EndpointsConfiguration.SECURITY_REALM).set((Object)name);
        this.singlePortBuilder.securityRealm(this.serverConfigurationBuilder.getSecurityRealm(name));
        return this;
    }

    public EndpointsConfigurationBuilder implicitConnectorSecurity(boolean implicitConnectorSecurity) {
        this.attributes.attribute(EndpointsConfiguration.IMPLICIT_CONNECTOR_SECURITY).set((Object)implicitConnectorSecurity);
        return this;
    }

    public List<ProtocolServerConfigurationBuilder<?, ?>> connectors() {
        return this.connectorBuilders;
    }

    public SinglePortServerConfigurationBuilder singlePort() {
        return this.singlePortBuilder;
    }

    public <T extends ProtocolServerConfigurationBuilder<?, ?>> T addConnector(Class<T> klass) {
        try {
            ProtocolServerConfigurationBuilder builder = (ProtocolServerConfigurationBuilder)klass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.connectorBuilders.add(builder);
            this.singlePortBuilder.applyConfigurationToProtocol(builder);
            return (T)builder;
        }
        catch (Exception e) {
            throw Server.log.cannotInstantiateProtocolServerConfigurationBuilder(klass, e);
        }
    }

    public void validate() {
        Map<Class, List<ProtocolServerConfigurationBuilder>> buildersPerClass = this.connectorBuilders.stream().collect(Collectors.groupingBy(Object::getClass));
        Optional<Map.Entry> repeated = buildersPerClass.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).findFirst();
        repeated.ifPresent(e -> {
            String names = ((List)e.getValue()).stream().map(ProtocolServerConfigurationBuilder::name).collect(Collectors.joining(","));
            throw Server.log.multipleEndpointsSameTypeFound(names);
        });
    }

    public EndpointsConfiguration create() {
        boolean implicitSecurity = (Boolean)this.attributes.attribute(EndpointsConfiguration.IMPLICIT_CONNECTOR_SECURITY).get() != false && this.singlePortBuilder.securityRealm() != null;
        ArrayList<ProtocolServerConfiguration> connectors = new ArrayList<ProtocolServerConfiguration>(this.connectorBuilders.size());
        for (ProtocolServerConfigurationBuilder<?, ?> builder : this.connectorBuilders) {
            if (implicitSecurity) {
                if (builder instanceof HotRodServerConfigurationBuilder) {
                    this.enableImplicitAuthentication(this.singlePortBuilder.securityRealm(), (HotRodServerConfigurationBuilder)builder);
                } else if (builder instanceof RestServerConfigurationBuilder) {
                    this.enableImplicitAuthentication(this.singlePortBuilder.securityRealm(), (RestServerConfigurationBuilder)builder);
                }
            }
            connectors.add((ProtocolServerConfiguration)builder.create());
        }
        return new EndpointsConfiguration(this.attributes.protect(), connectors, this.singlePortBuilder.create());
    }

    public EndpointsConfigurationBuilder read(EndpointsConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    private void enableImplicitAuthentication(ServerSecurityRealm securityRealm, HotRodServerConfigurationBuilder builder) {
        builder.authentication().enable().securityRealm(securityRealm.getName());
        String serverPrincipal = null;
        for (KerberosSecurityFactoryConfiguration identity : securityRealm.getServerIdentities().kerberosConfigurations()) {
            if (identity.getPrincipal().startsWith("hotrod/")) {
                builder.authentication().addMechanisms(new String[]{"GS2-KRB5", "GSSAPI"});
                serverPrincipal = identity.getPrincipal();
                break;
            }
            Server.log.debugf("Enabled Kerberos mechanisms for Hot Rod using principal '%s'", identity.getPrincipal());
        }
        if (securityRealm.hasFeature(ServerSecurityRealm.Feature.TOKEN)) {
            builder.authentication().addMechanisms(new String[]{"OAUTHBEARER"});
            Server.log.debug("Enabled OAUTHBEARER mechanism for Hot Rod");
        }
        if (securityRealm.hasFeature(ServerSecurityRealm.Feature.TRUST)) {
            builder.authentication().addMechanisms(new String[]{"EXTERNAL"});
            Server.log.debug("Enabled EXTERNAL mechanism for Hot Rod");
        }
        if (securityRealm.hasFeature(ServerSecurityRealm.Feature.PASSWORD)) {
            builder.authentication().addMechanisms(new String[]{"SCRAM-SHA-512", "SCRAM-SHA-384", "SCRAM-SHA-256", "SCRAM-SHA-1", "DIGEST-SHA-512", "DIGEST-SHA-384", "DIGEST-SHA-256", "DIGEST-SHA", "CRAM-MD5", "DIGEST-MD5"});
            Server.log.debug("Enabled SCRAM, DIGEST and CRAM mechanisms for Hot Rod");
        }
        if (this.singlePortBuilder.ssl().isEnabled()) {
            builder.authentication().addMechanisms(new String[]{"PLAIN"});
            Server.log.debug("Enabled PLAIN mechanism for Hot Rod");
        }
        builder.authentication().serverAuthenticationProvider(securityRealm.getSASLAuthenticationProvider(serverPrincipal));
    }

    private void enableImplicitAuthentication(ServerSecurityRealm securityRealm, RestServerConfigurationBuilder builder) {
        builder.authentication().enable().securityRealm(securityRealm.getName());
        String serverPrincipal = null;
        for (KerberosSecurityFactoryConfiguration identity : securityRealm.getServerIdentities().kerberosConfigurations()) {
            if (identity.getPrincipal().startsWith("HTTP/")) {
                builder.authentication().addMechanisms(new String[]{"SPNEGO"});
                serverPrincipal = identity.getPrincipal();
            }
            Server.log.debugf("Enabled SPNEGO authentication for HTTP using principal '%s'", identity.getPrincipal());
        }
        if (securityRealm.hasFeature(ServerSecurityRealm.Feature.TOKEN)) {
            builder.authentication().addMechanisms(new String[]{"BEARER_TOKEN"});
            Server.log.debug("Enabled BEARER_TOKEN for HTTP");
        }
        if (securityRealm.hasFeature(ServerSecurityRealm.Feature.TRUST)) {
            builder.authentication().addMechanisms(new String[]{"CLIENT_CERT"});
            Server.log.debug("Enabled CLIENT_CERT for HTTP");
        }
        if (securityRealm.hasFeature(ServerSecurityRealm.Feature.PASSWORD)) {
            builder.authentication().addMechanisms(new String[]{"DIGEST"});
            Server.log.debug("Enabled DIGEST for HTTP");
        }
        if (this.singlePortBuilder.ssl().isEnabled()) {
            builder.authentication().addMechanisms(new String[]{"BASIC"});
            Server.log.debug("Enabled BASIC for HTTP");
        }
        builder.authentication().authenticator(securityRealm.getHTTPAuthenticationProvider(serverPrincipal));
    }
}

