/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.DataSourcesConfigurationBuilder;
import org.infinispan.server.configuration.InterfacesConfigurationBuilder;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.configuration.SocketBindingsConfigurationBuilder;
import org.infinispan.server.configuration.endpoint.EndpointsConfigurationBuilder;
import org.infinispan.server.configuration.endpoint.SinglePortServerConfigurationBuilder;
import org.infinispan.server.configuration.security.SecurityConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.network.SocketBinding;
import org.infinispan.server.security.ServerSecurityRealm;

public class ServerConfigurationBuilder
implements Builder<ServerConfiguration> {
    private final GlobalConfigurationBuilder builder;
    private final InterfacesConfigurationBuilder interfaces = new InterfacesConfigurationBuilder();
    private final SocketBindingsConfigurationBuilder socketBindings = new SocketBindingsConfigurationBuilder(this);
    private final SecurityConfigurationBuilder security = new SecurityConfigurationBuilder();
    private final DataSourcesConfigurationBuilder dataSources = new DataSourcesConfigurationBuilder(this);
    private final EndpointsConfigurationBuilder endpoints = new EndpointsConfigurationBuilder(this);

    public ServerConfigurationBuilder(GlobalConfigurationBuilder builder) {
        this.builder = builder;
    }

    public List<ProtocolServerConfigurationBuilder<?, ?>> connectors() {
        return this.endpoints.connectors();
    }

    public SinglePortServerConfigurationBuilder endpoint() {
        return this.endpoints.singlePort();
    }

    public SecurityConfigurationBuilder security() {
        return this.security;
    }

    public InterfacesConfigurationBuilder interfaces() {
        return this.interfaces;
    }

    public SocketBindingsConfigurationBuilder socketBindings() {
        return this.socketBindings;
    }

    public DataSourcesConfigurationBuilder dataSources() {
        return this.dataSources;
    }

    public EndpointsConfigurationBuilder endpoints() {
        return this.endpoints;
    }

    public void validate() {
        Arrays.asList(this.interfaces, this.socketBindings, this.security, this.endpoints).forEach(Builder::validate);
    }

    public ServerConfiguration create() {
        return new ServerConfiguration(this.interfaces.create(), this.socketBindings.create(), this.security.create(), this.dataSources.create(), this.endpoints.create());
    }

    public Builder<?> read(ServerConfiguration template) {
        return this;
    }

    public ServerSecurityRealm getSecurityRealm(String name) {
        ServerSecurityRealm serverSecurityRealm = this.security.realms().getServerSecurityRealm(name);
        if (serverSecurityRealm == null) {
            throw Server.log.unknownSecurityDomain(name);
        }
        return serverSecurityRealm;
    }

    public boolean hasSSLContext(String name) {
        return this.security.realms().getSSLContext(name) != null;
    }

    public SSLContext getSSLContext(String name) {
        SSLContext sslContext = this.security.realms().getSSLContext(name);
        if (sslContext == null) {
            throw Server.log.unknownSecurityDomain(name);
        }
        return sslContext;
    }

    public void applySocketBinding(String bingingName, ProtocolServerConfigurationBuilder builder) {
        if (!this.socketBindings.exists(bingingName)) {
            throw Server.log.unknownSocketBinding(bingingName);
        }
        SocketBinding socketBinding = this.socketBindings.getSocketBinding(bingingName);
        String host = socketBinding.getAddress().getAddress().getHostAddress();
        int port = socketBinding.getPort();
        SinglePortServerConfigurationBuilder endpoint = this.endpoints().singlePort();
        if (builder != endpoint && endpoint.host().equals(host) && endpoint.port() == port) {
            throw Server.log.protocolCannotUseSameSocketBindingAsEndpoint();
        }
        builder.host(host).port(port);
    }
}

