/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.configuration.Element;

public class DataSourceConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((String)"name", null, String.class).build();
    static final AttributeDefinition<String> JNDI_NAME = AttributeDefinition.builder((String)"jndiName", null, String.class).build();
    static final AttributeDefinition<Boolean> STATISTICS = AttributeDefinition.builder((String)"statistics", (Object)false, Boolean.class).build();
    static final AttributeDefinition<String> DRIVER = AttributeDefinition.builder((String)"driver", null, String.class).build();
    static final AttributeDefinition<String> URL = AttributeDefinition.builder((String)"url", null, String.class).build();
    static final AttributeDefinition<String> USERNAME = AttributeDefinition.builder((String)"username", null, String.class).build();
    static final AttributeDefinition<String> PASSWORD = AttributeDefinition.builder((String)"password", null, String.class).build();
    static final AttributeDefinition<String> INITIAL_SQL = AttributeDefinition.builder((String)"initialSql", null, String.class).build();
    static final AttributeDefinition<AgroalConnectionFactoryConfiguration.TransactionIsolation> TRANSACTION_ISOLATION = AttributeDefinition.builder((String)"transactionIsolation", (Object)AgroalConnectionFactoryConfiguration.TransactionIsolation.READ_COMMITTED, AgroalConnectionFactoryConfiguration.TransactionIsolation.class).build();
    static final AttributeDefinition<Integer> MAX_SIZE = AttributeDefinition.builder((String)"maxSize", null, Integer.class).build();
    static final AttributeDefinition<Integer> MIN_SIZE = AttributeDefinition.builder((String)"minSize", (Object)0, Integer.class).build();
    static final AttributeDefinition<Integer> INITIAL_SIZE = AttributeDefinition.builder((String)"initialSize", (Object)0, Integer.class).build();
    static final AttributeDefinition<Long> BLOCKING_TIMEOUT = AttributeDefinition.builder((String)"blockingTimeout", (Object)0L, Long.class).build();
    static final AttributeDefinition<Long> BACKGROUND_VALIDATION = AttributeDefinition.builder((String)"backgroundValidation", (Object)0L, Long.class).build();
    static final AttributeDefinition<Long> LEAK_DETECTION = AttributeDefinition.builder((String)"leakDetection", (Object)0L, Long.class).build();
    static final AttributeDefinition<Integer> IDLE_REMOVAL = AttributeDefinition.builder((String)"idleRemoval", (Object)0, Integer.class).build();
    static final AttributeDefinition<Map<String, String>> CONNECTION_PROPERTIES = AttributeDefinition.builder((String)"connectionProperty", null, Map.class).initializer(LinkedHashMap::new).autoPersist(false).immutable().build();
    private static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.DATA_SOURCE.toString());
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(DataSourceConfiguration.class, new AttributeDefinition[]{NAME, JNDI_NAME, STATISTICS, DRIVER, URL, USERNAME, PASSWORD, INITIAL_SQL, TRANSACTION_ISOLATION, MAX_SIZE, MIN_SIZE, INITIAL_SIZE, BLOCKING_TIMEOUT, BACKGROUND_VALIDATION, LEAK_DETECTION, IDLE_REMOVAL, CONNECTION_PROPERTIES});
    }

    DataSourceConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String name() {
        return (String)this.attributes.attribute(NAME).get();
    }

    public String jndiName() {
        return (String)this.attributes.attribute(JNDI_NAME).get();
    }

    public Boolean statistics() {
        return (Boolean)this.attributes.attribute(STATISTICS).get();
    }

    public String driver() {
        return (String)this.attributes.attribute(DRIVER).get();
    }

    public String username() {
        return (String)this.attributes.attribute(USERNAME).get();
    }

    public String password() {
        return (String)this.attributes.attribute(PASSWORD).get();
    }

    public String url() {
        return (String)this.attributes.attribute(URL).get();
    }

    public AgroalConnectionFactoryConfiguration.TransactionIsolation transactionIsolation() {
        return (AgroalConnectionFactoryConfiguration.TransactionIsolation)this.attributes.attribute(TRANSACTION_ISOLATION).get();
    }

    public String initialSql() {
        return (String)this.attributes.attribute(INITIAL_SQL).get();
    }

    public int maxSize() {
        return (Integer)this.attributes.attribute(MAX_SIZE).get();
    }

    public int minSize() {
        return (Integer)this.attributes.attribute(MIN_SIZE).get();
    }

    public int initialSize() {
        return (Integer)this.attributes.attribute(INITIAL_SIZE).get();
    }

    public long blockingTimeout() {
        return (Long)this.attributes.attribute(BLOCKING_TIMEOUT).get();
    }

    public long backgroundValidation() {
        return (Long)this.attributes.attribute(BACKGROUND_VALIDATION).get();
    }

    public long leakDetection() {
        return (Long)this.attributes.attribute(LEAK_DETECTION).get();
    }

    public int idleRemoval() {
        return (Integer)this.attributes.attribute(IDLE_REMOVAL).get();
    }

    public Map<String, String> connectionProperties() {
        return (Map)this.attributes.attribute(CONNECTION_PROPERTIES).get();
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceConfiguration that = (DataSourceConfiguration)o;
        return this.attributes.equals((Object)that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        return "DataSourceConfiguration{attributes=" + this.attributes + '}';
    }
}

