/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.logging;

import org.infinispan.commons.CacheException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface Log
extends BasicLogger {
    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Could not register interpreter MBean", id=27501)
    public void jmxRegistrationFailed();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Could not unregister interpreter MBean", id=27502)
    public void jmxUnregistrationFailed();

    @Message(value="Script execution error", id=27503)
    public CacheException scriptExecutionError(@Cause Throwable var1);

    @Message(value="Compiler error for script '%s'", id=27504)
    public CacheException scriptCompilationException(@Cause Throwable var1, String var2);

    @Message(value="No script named '%s'", id=27505)
    public CacheException noNamedScript(String var1);

    @Message(value="Unknown script mode: '%s'", id=27506)
    public CacheException unknownScriptProperty(String var1);

    @Message(value="Cannot find an appropriate script engine for '%s'", id=27507)
    public IllegalArgumentException noScriptEngineForScript(String var1);

    @Message(value="Script '%s' cannot be invoked directly since it specifies mode '%s'", id=27508)
    public IllegalArgumentException cannotInvokeScriptDirectly(String var1, String var2);

    @Message(value="Distributed script '%s' invoked without a cache binding", id=27509)
    public IllegalStateException distributedTaskNeedCacheInBinding(String var1);

    @Message(value="Cannot find an appropriate script engine for script '%s'", id=27510)
    public IllegalArgumentException noEngineForScript(String var1);

    @Message(value="Script parameters must be declared using the array notation, e.g. [a,b,c]", id=27511)
    public IllegalArgumentException parametersNotArray();

    @Message(value="Scripts can only access named caches", id=27512)
    public IllegalArgumentException scriptsCanOnlyAccessNamedCaches();
}

