/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.logging;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.infinispan.commons.CacheException;
import org.infinispan.scripting.logging.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String scriptExecutionError$str() {
        return "ISPN027503: Script execution error";
    }

    @Override
    public final CacheException scriptExecutionError(Throwable t) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.scriptExecutionError$str(), new Object[0]), t);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String scriptCompilationException$str() {
        return "ISPN027504: Compiler error for script '%s'";
    }

    @Override
    public final CacheException scriptCompilationException(Throwable t, String name) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.scriptCompilationException$str(), name), t);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noNamedScript$str() {
        return "ISPN027505: No script named '%s'";
    }

    @Override
    public final CacheException noNamedScript(String name) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.noNamedScript$str(), name));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownScriptProperty$str() {
        return "ISPN027506: Unknown script mode: '%s'";
    }

    @Override
    public final CacheException unknownScriptProperty(String value) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.unknownScriptProperty$str(), value));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noScriptEngineForScript$str() {
        return "ISPN027507: Cannot find an appropriate script engine for '%s'";
    }

    @Override
    public final IllegalArgumentException noScriptEngineForScript(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noScriptEngineForScript$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotInvokeScriptDirectly$str() {
        return "ISPN027508: Script '%s' cannot be invoked directly since it specifies mode '%s'";
    }

    @Override
    public final IllegalArgumentException cannotInvokeScriptDirectly(String scriptName, String property) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotInvokeScriptDirectly$str(), scriptName, property));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String distributedTaskNeedCacheInBinding$str() {
        return "ISPN027509: Distributed script '%s' invoked without a cache binding";
    }

    @Override
    public final IllegalStateException distributedTaskNeedCacheInBinding(String scriptName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.distributedTaskNeedCacheInBinding$str(), scriptName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noEngineForScript$str() {
        return "ISPN027510: Cannot find an appropriate script engine for script '%s'";
    }

    @Override
    public final IllegalArgumentException noEngineForScript(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noEngineForScript$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String parametersNotArray$str() {
        return "ISPN027511: Script parameters must be declared using the array notation, e.g. [a,b,c]";
    }

    @Override
    public final IllegalArgumentException parametersNotArray() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.parametersNotArray$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String scriptsCanOnlyAccessNamedCaches$str() {
        return "ISPN027512: Scripts can only access named caches";
    }

    @Override
    public final IllegalArgumentException scriptsCanOnlyAccessNamedCaches() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.scriptsCanOnlyAccessNamedCaches$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

