/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.filter;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.objectfilter.impl.ProtobufMatcher;
import org.infinispan.query.dsl.embedded.impl.IckleFilterAndConverter;
import org.infinispan.query.remote.impl.ExternalizerIds;
import org.infinispan.query.remote.impl.RemoteQueryManager;

public final class IckleProtobufFilterAndConverter
extends IckleFilterAndConverter<Object, Object> {
    public IckleProtobufFilterAndConverter(String queryString, Map<String, Object> namedParameters) {
        super(queryString, namedParameters, ProtobufMatcher.class);
    }

    protected void injectDependencies(Cache cache) {
        RemoteQueryManager remoteQueryManager = (RemoteQueryManager)cache.getAdvancedCache().getComponentRegistry().getComponent(RemoteQueryManager.class);
        this.matcherImplClass = remoteQueryManager.getMatcherClass(MediaType.APPLICATION_PROTOSTREAM);
        super.injectDependencies(cache);
    }

    public static final class Externalizer
    extends AbstractExternalizer<IckleProtobufFilterAndConverter> {
        public void writeObject(ObjectOutput output, IckleProtobufFilterAndConverter filterAndConverter) throws IOException {
            output.writeUTF(filterAndConverter.getQueryString());
            Map namedParameters = filterAndConverter.getNamedParameters();
            if (namedParameters != null) {
                UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)namedParameters.size());
                for (Map.Entry e : namedParameters.entrySet()) {
                    output.writeUTF((String)e.getKey());
                    output.writeObject(e.getValue());
                }
            } else {
                UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)0);
            }
        }

        public IckleProtobufFilterAndConverter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String queryString = input.readUTF();
            int paramsSize = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            HashMap<String, Object> namedParameters = null;
            if (paramsSize != 0) {
                namedParameters = new HashMap<String, Object>(paramsSize);
                for (int i = 0; i < paramsSize; ++i) {
                    String paramName = input.readUTF();
                    Object paramValue = input.readObject();
                    namedParameters.put(paramName, paramValue);
                }
            }
            return new IckleProtobufFilterAndConverter(queryString, namedParameters);
        }

        public Integer getId() {
            return ExternalizerIds.ICKLE_PROTOBUF_FILTER_AND_CONVERTER;
        }

        public Set<Class<? extends IckleProtobufFilterAndConverter>> getTypeClasses() {
            return Collections.singleton(IckleProtobufFilterAndConverter.class);
        }
    }
}

