/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.impl.ProtobufMatcher;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.impl.BaseRemoteQueryEngine;
import org.infinispan.query.remote.impl.BaseRemoteQueryManager;
import org.infinispan.query.remote.impl.ProtobufFieldIndexingMetadata;
import org.infinispan.query.remote.impl.ProtobufWrapper;
import org.infinispan.query.remote.impl.QuerySerializers;
import org.infinispan.query.remote.impl.RemoteQueryEngine;

class ProtobufRemoteQueryManager
extends BaseRemoteQueryManager {
    private final RemoteQueryEngine queryEngine;
    private final Transcoder protobufTranscoder;

    ProtobufRemoteQueryManager(SerializationContext serCtx, ComponentRegistry cr, QuerySerializers querySerializers) {
        super(cr, querySerializers);
        ProtobufMatcher matcher = new ProtobufMatcher(serCtx, ProtobufFieldIndexingMetadata::new);
        cr.registerComponent((Object)matcher, ProtobufMatcher.class);
        Configuration configuration = this.cache.getCacheConfiguration();
        boolean isIndexed = configuration.indexing().index().isEnabled();
        boolean customStorage = configuration.encoding().valueDataType().isMediaTypeChanged();
        MediaType valueMediaType = this.valueDataConversion.getStorageMediaType();
        boolean isProtoBuf = valueMediaType.match(MediaType.APPLICATION_PROTOSTREAM);
        if (isProtoBuf || !customStorage && isIndexed) {
            this.valueDataConversion.overrideWrapper(ProtobufWrapper.class, cr);
        }
        this.queryEngine = new RemoteQueryEngine(this.cache, isIndexed);
        EncoderRegistry encoderRegistry = (EncoderRegistry)cr.getGlobalComponentRegistry().getComponent(EncoderRegistry.class);
        this.protobufTranscoder = encoderRegistry.getTranscoder(MediaType.APPLICATION_PROTOSTREAM, MediaType.APPLICATION_OBJECT);
    }

    @Override
    public Class<? extends Matcher> getMatcherClass(MediaType mediaType) {
        return ProtobufMatcher.class;
    }

    @Override
    public BaseRemoteQueryEngine getQueryEngine(AdvancedCache<?, ?> cache) {
        return this.queryEngine;
    }

    @Override
    public Object encodeFilterResult(Object filterResult) {
        return this.protobufTranscoder.transcode(filterResult, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_PROTOSTREAM);
    }
}

