/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.cfg.spi.ConvertUtils;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.infinispan.protostream.MessageContext;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.query.remote.impl.indexing.aggregator.TypeAggregator;
import org.infinispan.query.remote.impl.mapping.reference.IndexReferenceHolder;

public final class IndexingMessageContext
extends MessageContext<IndexingMessageContext> {
    private final DocumentElement document;
    private final TypeAggregator typeAggregator;
    private final IndexingMessageContext parentContext;
    private Map<String, List<Float>> vectorAggregators;
    private Map<String, GeoPointInfo> geoPoints;

    public IndexingMessageContext(IndexingMessageContext parentContext, FieldDescriptor fieldDescriptor, Descriptor messageDescriptor, DocumentElement document, TypeAggregator typeAggregator) {
        super((MessageContext)parentContext, fieldDescriptor, messageDescriptor);
        this.document = document;
        this.typeAggregator = typeAggregator;
        this.parentContext = parentContext;
    }

    public DocumentElement getDocument() {
        return this.document;
    }

    public TypeAggregator getTypeAggregator() {
        return this.typeAggregator;
    }

    public void addValue(IndexFieldReference fieldReference, Object value) {
        if (this.document != null) {
            this.document.addValue(fieldReference, value);
        }
    }

    public void addArrayItem(String fieldPath, Float value) {
        if (this.vectorAggregators == null) {
            this.vectorAggregators = new HashMap<String, List<Float>>();
        }
        this.vectorAggregators.putIfAbsent(fieldPath, new ArrayList(50));
        this.vectorAggregators.get(fieldPath).add(value);
    }

    public void addGeoValue(IndexReferenceHolder.GeoIndexFieldReference geoReference, Object value) {
        if (this.document == null) {
            this.parentContext.addGeoValue(geoReference, value);
            return;
        }
        if (this.geoPoints == null) {
            this.geoPoints = new HashMap<String, GeoPointInfo>();
        }
        Double converted = ConvertUtils.convertDouble((Object)value);
        String indexFieldName = geoReference.indexFieldName();
        this.geoPoints.putIfAbsent(indexFieldName, new GeoPointInfo(geoReference.fieldReference()));
        if (geoReference.role().equals((Object)IndexReferenceHolder.GeoIndexFieldReference.Role.LAT)) {
            this.geoPoints.get((Object)indexFieldName).latitude = converted;
        } else {
            this.geoPoints.get((Object)indexFieldName).longitude = converted;
        }
    }

    public void writeVectorAggregators(IndexReferenceHolder indexReferenceHolder) {
        if (this.vectorAggregators == null) {
            return;
        }
        for (Map.Entry<String, List<Float>> entry : this.vectorAggregators.entrySet()) {
            IndexFieldReference<?> fieldReference = indexReferenceHolder.getFieldReference(entry.getKey());
            List<Float> values = entry.getValue();
            float[] value = new float[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                value[i] = values.get(i).floatValue();
            }
            this.addValue(fieldReference, value);
        }
    }

    public void writeGeoPoints() {
        if (this.geoPoints == null) {
            return;
        }
        for (GeoPointInfo geoPointInfo : this.geoPoints.values()) {
            geoPointInfo.addValue(this.document);
        }
    }

    private static class GeoPointInfo {
        private final IndexFieldReference<GeoPoint> fieldReference;
        private Double latitude;
        private Double longitude;

        private GeoPointInfo(IndexFieldReference<GeoPoint> fieldReference) {
            this.fieldReference = fieldReference;
        }

        GeoPoint geoPoint() {
            return GeoPoint.of((double)this.latitude, (double)this.longitude);
        }

        void addValue(DocumentElement document) {
            document.addValue(this.fieldReference, (Object)this.geoPoint());
        }
    }
}

