/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing.infinispan;

import java.util.Map;
import org.infinispan.api.annotations.indexing.option.Structure;
import org.infinispan.api.annotations.indexing.option.TermVector;
import org.infinispan.api.annotations.indexing.option.VectorSimilarity;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.query.remote.impl.indexing.FieldMapping;
import org.infinispan.query.remote.impl.indexing.SpatialFieldMapping;
import org.infinispan.query.remote.impl.indexing.infinispan.InfinispanAnnotations;
import org.infinispan.query.remote.impl.logging.Log;

public final class InfinispanMetadataCreator {
    private static final Log log = (Log)LogFactory.getLog(InfinispanMetadataCreator.class, Log.class);

    public static FieldMapping fieldMapping(FieldDescriptor fieldDescriptor, Map<String, AnnotationElement.Annotation> annotations) {
        AnnotationElement.Annotation fieldAnnotation = annotations.get("Basic");
        if (fieldAnnotation != null) {
            return InfinispanMetadataCreator.basic(fieldDescriptor, fieldAnnotation);
        }
        fieldAnnotation = annotations.get("Keyword");
        if (fieldAnnotation != null) {
            return InfinispanMetadataCreator.keyword(fieldDescriptor, fieldAnnotation);
        }
        fieldAnnotation = annotations.get("Text");
        if (fieldAnnotation != null) {
            return InfinispanMetadataCreator.text(fieldDescriptor, fieldAnnotation);
        }
        fieldAnnotation = annotations.get("Decimal");
        if (fieldAnnotation != null) {
            return InfinispanMetadataCreator.decimal(fieldDescriptor, fieldAnnotation);
        }
        fieldAnnotation = annotations.get("Embedded");
        if (fieldAnnotation != null) {
            return InfinispanMetadataCreator.embedded(fieldDescriptor, fieldAnnotation);
        }
        fieldAnnotation = annotations.get("Vector");
        if (fieldAnnotation != null) {
            return InfinispanMetadataCreator.vector(fieldDescriptor, fieldAnnotation);
        }
        return null;
    }

    public static SpatialFieldMapping geoField(FieldDescriptor fieldDescriptor, Map<String, AnnotationElement.Annotation> annotations) {
        AnnotationElement.Annotation fieldAnnotation = annotations.get("GeoField");
        if (fieldAnnotation != null) {
            String fieldName = InfinispanMetadataCreator.name(fieldDescriptor, fieldAnnotation);
            Boolean projectable = (Boolean)fieldAnnotation.getAttributeValue("projectable").getValue();
            Boolean sortable = (Boolean)fieldAnnotation.getAttributeValue("sortable").getValue();
            return new SpatialFieldMapping(fieldName, "", projectable, sortable);
        }
        return null;
    }

    public static SpatialFieldMapping geoPoint(AnnotationElement.Annotation fieldAnnotation) {
        String fieldName = (String)fieldAnnotation.getAttributeValue("fieldName").getValue();
        Boolean projectable = (Boolean)fieldAnnotation.getAttributeValue("projectable").getValue();
        Boolean sortable = (Boolean)fieldAnnotation.getAttributeValue("sortable").getValue();
        return new SpatialFieldMapping(fieldName, fieldName, projectable, sortable);
    }

    private static FieldMapping basic(FieldDescriptor fieldDescriptor, AnnotationElement.Annotation fieldAnnotation) {
        String name = InfinispanMetadataCreator.name(fieldDescriptor, fieldAnnotation);
        String indexNullAs = InfinispanMetadataCreator.indexNullAs(fieldAnnotation);
        Boolean searchable = (Boolean)fieldAnnotation.getAttributeValue("searchable").getValue();
        Boolean projectable = (Boolean)fieldAnnotation.getAttributeValue("projectable").getValue();
        Boolean aggregable = (Boolean)fieldAnnotation.getAttributeValue("aggregable").getValue();
        Boolean sortable = (Boolean)fieldAnnotation.getAttributeValue("sortable").getValue();
        return FieldMapping.make(fieldDescriptor, name, searchable, projectable, aggregable, sortable).indexNullAs(indexNullAs).build();
    }

    private static FieldMapping keyword(FieldDescriptor fieldDescriptor, AnnotationElement.Annotation fieldAnnotation) {
        String name = InfinispanMetadataCreator.name(fieldDescriptor, fieldAnnotation);
        String indexNullAs = InfinispanMetadataCreator.indexNullAs(fieldAnnotation);
        Boolean searchable = (Boolean)fieldAnnotation.getAttributeValue("searchable").getValue();
        Boolean projectable = (Boolean)fieldAnnotation.getAttributeValue("projectable").getValue();
        Boolean aggregable = (Boolean)fieldAnnotation.getAttributeValue("aggregable").getValue();
        Boolean sortable = (Boolean)fieldAnnotation.getAttributeValue("sortable").getValue();
        String normalizer = (String)fieldAnnotation.getAttributeValue("normalizer").getValue();
        if ("".equals(normalizer)) {
            normalizer = null;
        }
        Boolean norms = (Boolean)fieldAnnotation.getAttributeValue("norms").getValue();
        return FieldMapping.make(fieldDescriptor, name, searchable, projectable, aggregable, sortable).indexNullAs(indexNullAs).keyword(normalizer, norms).build();
    }

    private static FieldMapping text(FieldDescriptor fieldDescriptor, AnnotationElement.Annotation fieldAnnotation) {
        String name = InfinispanMetadataCreator.name(fieldDescriptor, fieldAnnotation);
        Boolean searchable = (Boolean)fieldAnnotation.getAttributeValue("searchable").getValue();
        Boolean projectable = (Boolean)fieldAnnotation.getAttributeValue("projectable").getValue();
        String analyzer = (String)fieldAnnotation.getAttributeValue("analyzer").getValue();
        String searchAnalyzer = (String)fieldAnnotation.getAttributeValue("searchAnalyzer").getValue();
        if ("".equals(searchAnalyzer)) {
            searchAnalyzer = null;
        }
        Boolean norms = (Boolean)fieldAnnotation.getAttributeValue("norms").getValue();
        TermVector termVector = InfinispanAnnotations.termVector((String)fieldAnnotation.getAttributeValue("termVector").getValue());
        return FieldMapping.make(fieldDescriptor, name, searchable, projectable, false, false).text(analyzer, searchAnalyzer, norms, termVector).build();
    }

    private static FieldMapping decimal(FieldDescriptor fieldDescriptor, AnnotationElement.Annotation fieldAnnotation) {
        String name = InfinispanMetadataCreator.name(fieldDescriptor, fieldAnnotation);
        String indexNullAs = InfinispanMetadataCreator.indexNullAs(fieldAnnotation);
        Boolean searchable = (Boolean)fieldAnnotation.getAttributeValue("searchable").getValue();
        Boolean projectable = (Boolean)fieldAnnotation.getAttributeValue("projectable").getValue();
        Boolean aggregable = (Boolean)fieldAnnotation.getAttributeValue("aggregable").getValue();
        Boolean sortable = (Boolean)fieldAnnotation.getAttributeValue("sortable").getValue();
        Integer decimalScale = (Integer)fieldAnnotation.getAttributeValue("decimalScale").getValue();
        return FieldMapping.make(fieldDescriptor, name, searchable, projectable, aggregable, sortable).indexNullAs(indexNullAs).decimalScale(decimalScale).build();
    }

    private static FieldMapping vector(FieldDescriptor fieldDescriptor, AnnotationElement.Annotation fieldAnnotation) {
        String name = InfinispanMetadataCreator.name(fieldDescriptor, fieldAnnotation);
        String indexNullAs = InfinispanMetadataCreator.indexNullAs(fieldAnnotation);
        Boolean searchable = (Boolean)fieldAnnotation.getAttributeValue("searchable").getValue();
        Boolean projectable = (Boolean)fieldAnnotation.getAttributeValue("projectable").getValue();
        Integer dimension = (Integer)fieldAnnotation.getAttributeValue("dimension").getValue();
        if (dimension == null) {
            throw log.dimensionAttributeRequired(name);
        }
        VectorSimilarity similarity = InfinispanAnnotations.vectorSimilarity((String)fieldAnnotation.getAttributeValue("similarity").getValue());
        Integer beamWidth = (Integer)fieldAnnotation.getAttributeValue("beamWidth").getValue();
        Integer maxConnection = (Integer)fieldAnnotation.getAttributeValue("maxConnections").getValue();
        return FieldMapping.make(fieldDescriptor, name, searchable, projectable, false, false).indexNullAs(indexNullAs).vector(dimension, similarity, beamWidth, maxConnection).build();
    }

    private static FieldMapping embedded(FieldDescriptor fieldDescriptor, AnnotationElement.Annotation fieldAnnotation) {
        String name = InfinispanMetadataCreator.name(fieldDescriptor, fieldAnnotation);
        Integer includeDepth = (Integer)fieldAnnotation.getAttributeValue("includeDepth").getValue();
        Structure structure = InfinispanAnnotations.structure((String)fieldAnnotation.getAttributeValue("structure").getValue());
        return FieldMapping.make(fieldDescriptor, name, true, false, false, false).embedded(includeDepth, structure).build();
    }

    private static String name(FieldDescriptor fieldDescriptor, AnnotationElement.Annotation fieldAnnotation) {
        String name = (String)fieldAnnotation.getAttributeValue("name").getValue();
        if (name == null || name.isEmpty()) {
            name = fieldDescriptor.getName();
        }
        return name;
    }

    private static String fieldName(FieldDescriptor fieldDescriptor, AnnotationElement.Annotation fieldAnnotation) {
        String name = (String)fieldAnnotation.getAttributeValue("fieldName").getValue();
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return fieldDescriptor == null ? null : fieldDescriptor.getName();
    }

    private static String indexNullAs(AnnotationElement.Annotation fieldAnnotation) {
        String indexNullAs = (String)fieldAnnotation.getAttributeValue("indexNullAs").getValue();
        if ("__Infinispan_indexNullAs_doNotIndexNull".equals(indexNullAs)) {
            indexNullAs = null;
        }
        return indexNullAs;
    }
}

