/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.cli.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser80;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.persistence.cli.configuration.Attribute;
import org.infinispan.persistence.cli.configuration.CLInterfaceLoaderConfigurationBuilder;
import org.infinispan.persistence.cli.configuration.Element;

@Namespaces(value={@Namespace(uri="urn:infinispan:config:store:cli:8.0", root="cli-loader"), @Namespace(root="cli-loader")})
public class CLInterfaceLoaderConfigurationParser80
implements ConfigurationParser {
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case CLI_LOADER: {
                this.parseCliLoader(reader, builder.persistence());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseCliLoader(XMLExtendedStreamReader reader, PersistenceConfigurationBuilder persistence) throws XMLStreamException {
        CLInterfaceLoaderConfigurationBuilder builder = new CLInterfaceLoaderConfigurationBuilder(persistence);
        this.parseCliLoaderAttributes(reader, builder);
        persistence.addStore((StoreConfigurationBuilder)builder);
    }

    private void parseCliLoaderAttributes(XMLExtendedStreamReader reader, CLInterfaceLoaderConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            String attrName = reader.getAttributeLocalName(i);
            Attribute attribute = Attribute.forName(attrName);
            switch (attribute) {
                case CONNECTION: {
                    builder.connectionString(value);
                    continue block3;
                }
                default: {
                    Parser80.parseStoreAttribute((XMLExtendedStreamReader)reader, (int)i, (AbstractStoreConfigurationBuilder)builder);
                }
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }
}

