/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.component.processor.external;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.infinispan.external.JGroupsProtocolComponent;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.MsgStats;
import org.jgroups.protocols.RED;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.util.ThreadPool;
import org.jgroups.util.Util;

@SupportedAnnotationTypes(value={"org.infinispan.external.JGroupsProtocolComponent"})
public class JGroupsComponentProcessor
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                JGroupsProtocolComponent component = element.getAnnotation(JGroupsProtocolComponent.class);
                DeclaredType typeMirror = (DeclaredType)element.asType();
                TypeElement type = (TypeElement)typeMirror.asElement();
                String fqcn = type.getQualifiedName().toString();
                int lastDot = fqcn.lastIndexOf(46);
                String packageName = fqcn.substring(0, lastDot);
                try (PrintWriter w = new PrintWriter(this.processingEnv.getFiler().createSourceFile(packageName + "." + component.value(), new Element[0]).openWriter());){
                    this.generate(w, packageName, component.value());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return true;
    }

    public void generate(PrintWriter w, String packageName, String className) throws IOException {
        w.printf("package %s;%n", packageName);
        w.println("import java.util.ArrayList;");
        w.println("import java.util.Collection;");
        w.println("import java.util.HashMap;");
        w.println("import java.util.List;");
        w.println("import java.util.Map;");
        w.println("import java.util.function.Function;");
        w.println("import javax.annotation.processing.Generated;");
        w.println("import org.infinispan.commons.stat.GaugeMetricInfo;");
        w.println("import org.infinispan.commons.stat.MetricInfo;");
        w.println("import org.jgroups.stack.Protocol;");
        w.println();
        w.printf("@Generated(value = \"%s\", date = \"%s\")%n", this.getClass().getName(), Instant.now().toString());
        w.printf("public class %s {%n", className);
        w.println("   public static final Map<Class<? extends Protocol>, Collection<MetricInfo>> PROTOCOL_METADATA = new HashMap<>();");
        w.printf("   private %s() {}%n", className);
        w.println("   static {");
        w.println("      List<MetricInfo> attributes;");
        for (short id = 0; id < 256; id = (short)(id + 1)) {
            Class protocol = ClassConfigurator.getProtocol((short)id);
            JGroupsComponentProcessor.addProtocol(protocol, w);
        }
        if (ClassConfigurator.getProtocolId(RED.class) == 0) {
            JGroupsComponentProcessor.addProtocol(RED.class, w);
        }
        w.println("   }");
        w.println("}");
        w.println();
        w.flush();
        w.close();
    }

    private static void addProtocol(Class<?> protocol, PrintWriter w) {
        if (protocol == null || !Protocol.class.isAssignableFrom(protocol) || Modifier.isAbstract(protocol.getModifiers())) {
            return;
        }
        Map<String, JGroupsMetrics> methods = JGroupsComponentProcessor.findAndWriteMetrics(protocol, null);
        AtomicBoolean hasAttributes = new AtomicBoolean(false);
        if (!methods.isEmpty()) {
            if (hasAttributes.compareAndSet(false, true)) {
                w.println("      attributes = new ArrayList<>();");
            }
            methods.values().forEach(m -> m.write(w));
        }
        if (TP.class.isAssignableFrom(protocol)) {
            JGroupsComponentProcessor.addTPComponent("getThreadPool", protocol, ThreadPool.class, w, hasAttributes);
            JGroupsComponentProcessor.addTPComponent("getMessageStats", protocol, MsgStats.class, w, hasAttributes);
        }
        if (hasAttributes.get()) {
            w.printf("      PROTOCOL_METADATA.put(%s.class, attributes);%n", protocol.getName());
        }
    }

    private static boolean isNumber(Class<?> type) {
        return Short.TYPE == type || Byte.TYPE == type || Long.TYPE == type || Integer.TYPE == type || Float.TYPE == type || Double.TYPE == type || Number.class.isAssignableFrom(type);
    }

    private static void addTPComponent(String getterMethodName, Class<?> protocol, Class<?> component, PrintWriter w, AtomicBoolean hasAttributes) {
        Map<String, JGroupsMetrics> methods = JGroupsComponentProcessor.findAndWriteMetrics(component, protocol);
        if (methods.isEmpty()) {
            return;
        }
        if (hasAttributes.compareAndSet(false, true)) {
            w.println("      attributes = new ArrayList<>();");
        }
        methods.values().forEach(m -> m.writeComponent(w, getterMethodName));
    }

    private static Map<String, JGroupsMetrics> findAndWriteMetrics(Class<?> clazz, Class<?> rootClass) {
        ManagedAttribute annotation;
        TreeMap<String, JGroupsMetrics> metrics = new TreeMap<String, JGroupsMetrics>();
        String className = rootClass == null ? clazz.getName() : rootClass.getName();
        for (Method method : clazz.getMethods()) {
            annotation = method.getAnnotation(ManagedAttribute.class);
            if (annotation == null || JGroupsComponentProcessor.isMethodInvalid(method)) continue;
            metrics.put(method.getName(), new JGroupsMetrics(className, method.getName(), annotation.description()));
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            String methodName;
            Method method;
            annotation = ((Field)accessibleObject).getAnnotation(ManagedAttribute.class);
            if (annotation == null || Modifier.isStatic(((Field)accessibleObject).getModifiers()) || JGroupsComponentProcessor.isMethodInvalid(method = Util.findMethod(clazz, List.of((methodName = Util.attributeNameToMethodName((String)((Field)accessibleObject).getName())).substring(0, 1).toLowerCase() + methodName.substring(1), "get" + methodName), (Class[])new Class[0]))) continue;
            metrics.put(method.getName(), new JGroupsMetrics(className, method.getName(), annotation.description()));
        }
        return metrics;
    }

    private static boolean isMethodInvalid(Method method) {
        return method == null || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getParameterCount() != 0 || !JGroupsComponentProcessor.isNumber(method.getReturnType());
    }

    private record JGroupsMetrics(String className, String name, String description) {
        private JGroupsMetrics(String className, String name, String description) {
            this.className = Objects.requireNonNull(className);
            this.name = Objects.requireNonNull(name);
            this.description = Objects.requireNonNull(description).replace('\"', '\'');
        }

        void write(PrintWriter w) {
            w.printf("      attributes.add(new GaugeMetricInfo<>(\"%s\", \"%s\", null, %s::%s));%n", this.name, this.description, this.className, this.name);
        }

        void writeComponent(PrintWriter w, String componentGetterMethod) {
            w.printf("      attributes.add(new GaugeMetricInfo<>(\"%s\", \"%s\", null, ((Function<%s, Number>) p -> p.%s().%s())));%n", this.name, this.description, this.className, componentGetterMethod, this.name);
        }
    }
}

