/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.cli.commands.Command;
import org.infinispan.commons.util.ServiceFinder;

public class CommandRegistry {
    private Map<String, Command> commands = new HashMap<String, Command>();

    public CommandRegistry() {
        for (Command cmd : ServiceFinder.load(Command.class, (ClassLoader[])new ClassLoader[0])) {
            String name = cmd.getName();
            if (this.commands.containsKey(name)) {
                throw new RuntimeException("Command " + cmd.getClass().getName() + " overrides " + this.commands.get(name).getClass().getName());
            }
            this.commands.put(name, cmd);
        }
    }

    public Set<String> getCommandNames() {
        return Collections.unmodifiableSet(this.commands.keySet());
    }

    public Command getCommand(String name) {
        return this.commands.get(name);
    }
}

