/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.logging;

import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.aesh.command.parser.RequiredOptionException;
import org.aesh.io.Resource;
import org.infinispan.cli.completers.EncryptionCompleter;
import org.infinispan.cli.completers.ExposeCompleter;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.patching.PatchInfo;
import org.infinispan.cli.patching.PatchOperation;
import org.infinispan.cli.resources.Resource;
import org.infinispan.cli.user.UserTool;

public class Messages_$bundle
implements Messages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Messages_$bundle INSTANCE = new Messages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected Messages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String username$str() {
        return "Username: ";
    }

    @Override
    public final String username() {
        return String.format(this.getLoggingLocale(), this.username$str(), new Object[0]);
    }

    protected String password$str() {
        return "Password: ";
    }

    @Override
    public final String password() {
        return String.format(this.getLoggingLocale(), this.password$str(), new Object[0]);
    }

    protected String notFound$str() {
        return "Not Found: %s";
    }

    @Override
    public final IOException notFound(String s) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.notFound$str(), s));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String unauthorized$str() {
        return "The supplied credentials are invalid %s";
    }

    @Override
    public final AccessDeniedException unauthorized(String s) {
        AccessDeniedException result = new AccessDeniedException(String.format(this.getLoggingLocale(), this.unauthorized$str(), s));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String error$str() {
        return "Error: %s";
    }

    @Override
    public final IOException error(String s) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.error$str(), s));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String forbidden$str() {
        return "The user is not allowed to access the server resource: %s";
    }

    @Override
    public final AccessDeniedException forbidden(String s) {
        AccessDeniedException result = new AccessDeniedException(String.format(this.getLoggingLocale(), this.forbidden$str(), s));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String keyStoreError$str() {
        return "Error while configuring SSL";
    }

    @Override
    public final String keyStoreError(Exception e) {
        return String.format(this.getLoggingLocale(), this.keyStoreError$str(), new Object[0]);
    }

    protected String noSuchResource$str() {
        return "No such resource '%s'";
    }

    @Override
    public final IllegalArgumentException noSuchResource(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noSuchResource$str(), name));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalContext$str() {
        return "Command invoked from the wrong context";
    }

    @Override
    public final IllegalStateException illegalContext() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalContext$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalCommandArguments$str() {
        return "Illegal arguments for command";
    }

    @Override
    public final IllegalArgumentException illegalCommandArguments() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalCommandArguments$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mutuallyExclusiveOptions$str() {
        return "The options '%s' are mutually exclusive";
    }

    @Override
    public final IllegalArgumentException mutuallyExclusiveOptions(String ... opts) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mutuallyExclusiveOptions$str(), Arrays.toString(opts)));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String requiresOneOf$str() {
        return "One of the '%s' options is required";
    }

    @Override
    public final RequiredOptionException requiresOneOf(String ... opts) {
        RequiredOptionException result = new RequiredOptionException(String.format(this.getLoggingLocale(), this.requiresOneOf$str(), Arrays.toString(opts)));
        Messages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String connectionFailed$str() {
        return "Could not connect to server: %s";
    }

    @Override
    public final ConnectException connectionFailed(String message) {
        ConnectException result = new ConnectException(String.format(this.getLoggingLocale(), this.connectionFailed$str(), message));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidResource$str() {
        return "Invalid resource '%s'";
    }

    @Override
    public final IllegalArgumentException invalidResource(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidResource$str(), name));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String patchNoPatchesInstalled$str() {
        return "No patches installed";
    }

    @Override
    public final String patchNoPatchesInstalled() {
        return String.format(this.getLoggingLocale(), this.patchNoPatchesInstalled$str(), new Object[0]);
    }

    protected String patchInfo$str() {
        return "%s";
    }

    @Override
    public final String patchInfo(PatchInfo patchInfo) {
        return String.format(this.getLoggingLocale(), this.patchInfo$str(), patchInfo);
    }

    protected String patchCannotApply$str() {
        return "The supplied patch cannot be applied to %s %s";
    }

    @Override
    public final IllegalStateException patchCannotApply(String brandName, String version) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.patchCannotApply$str(), brandName, version));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String patchShaMismatch$str() {
        return "File %s SHA mismatch. Expected = %s, Actual = %s";
    }

    @Override
    public final String patchShaMismatch(Path path, String digest, String sha256) {
        return String.format(this.getLoggingLocale(), this.patchShaMismatch$str(), path, digest, sha256);
    }

    protected String patchValidationErrors$str() {
        return "The following errors were encountered while validating the installation:%n%s";
    }

    @Override
    public final IllegalStateException patchValidationErrors(String errors) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.patchValidationErrors$str(), errors));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String patchNoPatchesInstalledToRollback$str() {
        return "No installed patches to roll back";
    }

    @Override
    public final IllegalStateException patchNoPatchesInstalledToRollback() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.patchNoPatchesInstalledToRollback$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String patchCannotFindCommons$str() {
        return "Cannot find the infinispan-commons jar under %s";
    }

    @Override
    public final IllegalStateException patchCannotFindCommons(Path lib) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.patchCannotFindCommons$str(), lib));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String patchIncompatibleProduct$str() {
        return "Cannot create patch %s with patches for %s";
    }

    @Override
    public final IllegalStateException patchIncompatibleProduct(String localBrand, String patchBrand) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.patchIncompatibleProduct$str(), localBrand, patchBrand));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String patchCannotWritePatchesFile$str() {
        return "Could not write patches file";
    }

    @Override
    public final IllegalStateException patchCannotWritePatchesFile(IOException e) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.patchCannotWritePatchesFile$str(), new Object[0]), e);
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String patchRollback$str() {
        return "Rolled back patch %s";
    }

    @Override
    public final String patchRollback(PatchInfo patchInfo) {
        return String.format(this.getLoggingLocale(), this.patchRollback$str(), patchInfo);
    }

    protected String patchDryRun$str() {
        return "[Dry run] ";
    }

    @Override
    public final String patchDryRun() {
        return String.format(this.getLoggingLocale(), this.patchDryRun$str(), new Object[0]);
    }

    protected String patchBackup$str() {
        return "Backing up '%s' to '%s'";
    }

    @Override
    public final String patchBackup(Path from, Path to) {
        return String.format(this.getLoggingLocale(), this.patchBackup$str(), from, to);
    }

    protected String patchCreateError$str() {
        return "Error while creating patch";
    }

    @Override
    public final RuntimeException patchCreateError(IOException e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.patchCreateError$str(), new Object[0]), e);
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String patchCreateAdd$str() {
        return "Adding file '%s'";
    }

    @Override
    public final String patchCreateAdd(Path target) {
        return String.format(this.getLoggingLocale(), this.patchCreateAdd$str(), target);
    }

    protected String patchRollbackFile$str() {
        return "Rolling back file '%s'";
    }

    @Override
    public final String patchRollbackFile(Path file) {
        return String.format(this.getLoggingLocale(), this.patchRollbackFile$str(), file);
    }

    protected String patchCannotRead$str() {
        return "Could not read %s";
    }

    @Override
    public final IllegalStateException patchCannotRead(Path patchesFile, IOException e) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.patchCannotRead$str(), patchesFile), e);
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String patchFileAlreadyExists$str() {
        return "File '%s' already exists";
    }

    @Override
    public final FileAlreadyExistsException patchFileAlreadyExists(Path patch) {
        FileAlreadyExistsException result = new FileAlreadyExistsException(String.format(this.getLoggingLocale(), this.patchFileAlreadyExists$str(), patch));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String patchCreateArgumentsRequired$str() {
        return "At least three arguments are required: the patch file, the target server path and one or more source server paths";
    }

    @Override
    public final IllegalArgumentException patchCreateArgumentsRequired() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.patchCreateArgumentsRequired$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String patchArchiveArgumentRequired$str() {
        return "You must specify the path to a patch archive";
    }

    @Override
    public final IllegalArgumentException patchArchiveArgumentRequired() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.patchArchiveArgumentRequired$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String patchServerAndTargetMustBeDifferent$str() {
        return "Cannot create a patch from identical source and target server versions: %s";
    }

    @Override
    public final IllegalArgumentException patchServerAndTargetMustBeDifferent(String version) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.patchServerAndTargetMustBeDifferent$str(), version));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String patchCorruptArchive$str() {
        return "The patch archive appears to have a corrupt entry for: %s";
    }

    @Override
    public final String patchCorruptArchive(PatchOperation operation) {
        return String.format(this.getLoggingLocale(), this.patchCorruptArchive$str(), operation);
    }

    protected String downloadedFile$str() {
        return "Downloaded file '%s'";
    }

    @Override
    public final String downloadedFile(String filename) {
        return String.format(this.getLoggingLocale(), this.downloadedFile$str(), filename);
    }

    protected String userToolUsername$str() {
        return "Specify a username: ";
    }

    @Override
    public final String userToolUsername() {
        return String.format(this.getLoggingLocale(), this.userToolUsername$str(), new Object[0]);
    }

    protected String userToolPassword$str() {
        return "Set a password for the user: ";
    }

    @Override
    public final String userToolPassword() {
        return String.format(this.getLoggingLocale(), this.userToolPassword$str(), new Object[0]);
    }

    protected String userToolPasswordConfirm$str() {
        return "Confirm the password for the user: ";
    }

    @Override
    public final String userToolPasswordConfirm() {
        return String.format(this.getLoggingLocale(), this.userToolPasswordConfirm$str(), new Object[0]);
    }

    protected String userToolUserExists$str() {
        return "User `%s` already exists";
    }

    @Override
    public final IllegalStateException userToolUserExists(String username) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.userToolUserExists$str(), username));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String userToolIOError$str() {
        return "Error accessing file '%s'";
    }

    @Override
    public final RuntimeException userToolIOError(Path path, IOException e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.userToolIOError$str(), path), e);
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String userToolUnknownAlgorithm$str() {
        return "Unkown password encryption algorithm: '%s'";
    }

    @Override
    public final IllegalArgumentException userToolUnknownAlgorithm(String algorithm) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.userToolUnknownAlgorithm$str(), algorithm));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String userToolNoSuchUser$str() {
        return "User `%s` does not exist";
    }

    @Override
    public final IllegalArgumentException userToolNoSuchUser(String username) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.userToolNoSuchUser$str(), username));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String userDescribe$str() {
        return "{ username: \"%s\", realm: \"%s\", groups = %s }";
    }

    @Override
    public final String userDescribe(String username, String realm, String[] userGroups) {
        return String.format(this.getLoggingLocale(), this.userDescribe$str(), username, realm, Arrays.toString(userGroups));
    }

    protected String invalidUnicodeSequence$str() {
        return "Invalid Unicode sequence '%s'";
    }

    @Override
    public final IOException invalidUnicodeSequence(String sequence, NoSuchElementException e) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.invalidUnicodeSequence$str(), sequence), e);
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String userToolIncompatibleEncrypyion$str() {
        return "Attempt to use %s passwords, but only %s passwords are allowed";
    }

    @Override
    public final IllegalArgumentException userToolIncompatibleEncrypyion(UserTool.Encryption encryption1, UserTool.Encryption encryption2) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.userToolIncompatibleEncrypyion$str(), new Object[]{encryption1, encryption2}));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String userToolWrongRealm$str() {
        return "Attempted to use a different realm '%s' than the already existing one '%s'";
    }

    @Override
    public final IllegalArgumentException userToolWrongRealm(String realm1, String realm2) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.userToolWrongRealm$str(), realm1, realm2));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String configLoadFailed$str() {
        return "Unable to load CLI configuration from `%s`. Using defaults.";
    }

    @Override
    public final String configLoadFailed(String path) {
        return String.format(this.getLoggingLocale(), this.configLoadFailed$str(), path);
    }

    protected String configStoreFailed$str() {
        return "Unable to store CLI configuration to '%s'.";
    }

    @Override
    public final String configStoreFailed(String path) {
        return String.format(this.getLoggingLocale(), this.configStoreFailed$str(), path);
    }

    protected String wrongArgumentCount$str() {
        return "Wrong argument count: %d.";
    }

    @Override
    public final IllegalArgumentException wrongArgumentCount(int size) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.wrongArgumentCount$str(), size));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSuchService$str() {
        return "Cannot find service '%s' in namespace '%s'";
    }

    @Override
    public final IllegalArgumentException noSuchService(String serviceName, String namespace) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noSuchService$str(), serviceName, namespace));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noGeneratedSecret$str() {
        return "Cannot find or access generated secrets for service '%s'";
    }

    @Override
    public final IllegalStateException noGeneratedSecret(String serviceName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noGeneratedSecret$str(), serviceName));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noDefaultNamespace$str() {
        return "A namespace was not specified and a default has not been set";
    }

    @Override
    public final IllegalStateException noDefaultNamespace() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noDefaultNamespace$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String credentialToolPassword$str() {
        return "Enter the password for the credential keystore: ";
    }

    @Override
    public final String credentialToolPassword() {
        return String.format(this.getLoggingLocale(), this.credentialToolPassword$str(), new Object[0]);
    }

    protected String credentialToolPasswordConfirm$str() {
        return "Confirm the password for the credential store: ";
    }

    @Override
    public final String credentialToolPasswordConfirm() {
        return String.format(this.getLoggingLocale(), this.credentialToolPasswordConfirm$str(), new Object[0]);
    }

    protected String credentialToolCredential$str() {
        return "Set a credential for the alias: ";
    }

    @Override
    public final String credentialToolCredential() {
        return String.format(this.getLoggingLocale(), this.credentialToolCredential$str(), new Object[0]);
    }

    protected String credentialToolCredentialConfirm$str() {
        return "Confirm the credential: ";
    }

    @Override
    public final String credentialToolCredentialConfirm() {
        return String.format(this.getLoggingLocale(), this.credentialToolCredentialConfirm$str(), new Object[0]);
    }

    protected String illegalFilterRule$str() {
        return "Filter rule '%s' is not in the format [ACCEPT|REJECT]/{CIDR}";
    }

    @Override
    public final IllegalArgumentException illegalFilterRule(String rule) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalFilterRule$str(), rule));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String batchError$str() {
        return "Batch error: %s, line %d: '%s'";
    }

    @Override
    public final String batchError(String file, int lineNumber, String line, Throwable t) {
        return String.format(this.getLoggingLocale(), this.batchError$str(), file, lineNumber, line);
    }

    protected String requiresAllOf$str() {
        return "Option '%s' requires option '%s'";
    }

    @Override
    public final RequiredOptionException requiresAllOf(String option1, String option2) {
        RequiredOptionException result = new RequiredOptionException(String.format(this.getLoggingLocale(), this.requiresAllOf$str(), option1, option2));
        Messages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingCacheName$str() {
        return "The cache name is required";
    }

    @Override
    public final IllegalArgumentException missingCacheName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.missingCacheName$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noCatalog$str() {
        return "Could not determine catalog source";
    }

    @Override
    public final IllegalStateException noCatalog() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noCatalog$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noTargetNamespaces$str() {
        return "Target namespaces must be specified when not installing globally";
    }

    @Override
    public final IllegalArgumentException noTargetNamespaces() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noTargetNamespaces$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noDefaultOperatorNamespace$str() {
        return "Could not find a default operator namespace";
    }

    @Override
    public final IllegalStateException noDefaultOperatorNamespace() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noDefaultOperatorNamespace$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noKubernetes$str() {
        return "Kubernetes client is unavailable in this mode";
    }

    @Override
    public final IllegalStateException noKubernetes() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noKubernetes$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noOperatorSubscription$str() {
        return "Could not find an operator subscription in namespace '%s'";
    }

    @Override
    public final IllegalStateException noOperatorSubscription(String namespace) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noOperatorSubscription$str(), namespace));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String exposeTypeRequiresPort$str() {
        return "Expose type '%s' requires a port";
    }

    @Override
    public final IllegalArgumentException exposeTypeRequiresPort(ExposeCompleter.Expose exposeType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.exposeTypeRequiresPort$str(), new Object[]{exposeType}));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String encryptionTypeRequiresSecret$str() {
        return "Encryption type '%s' requires a secret name";
    }

    @Override
    public final IllegalArgumentException encryptionTypeRequiresSecret(EncryptionCompleter.Encryption encryptionType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.encryptionTypeRequiresSecret$str(), new Object[]{encryptionType}));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noRunningPodsInService$str() {
        return "No running pods available in service %s";
    }

    @Override
    public final IllegalStateException noRunningPodsInService(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noRunningPodsInService$str(), name));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String usernameRequired$str() {
        return "A username must be specified";
    }

    @Override
    public final IllegalArgumentException usernameRequired() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.usernameRequired$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String checksumFailed$str() {
        return "Checksum for '%s' does not match. Supplied: %s Actual: %s";
    }

    @Override
    public final SecurityException checksumFailed(String path, String checksum, String computed) {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.checksumFailed$str(), path, checksum, computed));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String checksumVerified$str() {
        return "Checksum for '%s' verified";
    }

    @Override
    public final String checksumVerified(String path) {
        return String.format(this.getLoggingLocale(), this.checksumVerified$str(), path);
    }

    protected String artifactNotFound$str() {
        return "Artifact '%s' not found";
    }

    @Override
    public final IllegalArgumentException artifactNotFound(String path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.artifactNotFound$str(), path));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String retryDownload$str() {
        return "Retry download '%d/%d'";
    }

    @Override
    public final String retryDownload(int retry, int retries) {
        return String.format(this.getLoggingLocale(), this.retryDownload$str(), retry, retries);
    }

    protected String unsupportedListFormat$str() {
        return "The resource does not support the '%s' list format";
    }

    @Override
    public final IllegalArgumentException unsupportedListFormat(Resource.ListFormat format) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unsupportedListFormat$str(), new Object[]{format}));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotResetIndividualStat$str() {
        return "Cannot reset an individual statistic";
    }

    @Override
    public final IllegalArgumentException cannotResetIndividualStat() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotResetIndividualStat$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonExistentFile$str() {
        return "File '%s' does not exist";
    }

    @Override
    public final NoSuchFileException nonExistentFile(Resource file) {
        NoSuchFileException result = new NoSuchFileException(String.format(this.getLoggingLocale(), this.nonExistentFile$str(), file));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingStoreMigratorProperties$str() {
        return "The store migrator requires configuration properties to be set";
    }

    @Override
    public final IllegalArgumentException missingStoreMigratorProperties() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.missingStoreMigratorProperties$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String generatedUser$str() {
        return "Generated User: %s";
    }

    @Override
    public final String generatedUser(String username) {
        return String.format(this.getLoggingLocale(), this.generatedUser$str(), username);
    }

    protected String generatedPassword$str() {
        return "Generated Password: %s";
    }

    @Override
    public final String generatedPassword(String password) {
        return String.format(this.getLoggingLocale(), this.generatedPassword$str(), password);
    }
}

