/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.impl.KubernetesContext;

@CommandDefinition(name="version", description="Shows version information")
public class Version
extends CliCommand {
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(String.format("CLI: %s", org.infinispan.commons.util.Version.printVersion()));
        if (invocation.getContext().isConnected()) {
            invocation.println("Server: " + invocation.getContext().getConnection().getServerVersion());
        }
        if (invocation.getContext() instanceof KubernetesContext) {
            KubernetesClient client = ((KubernetesContext)invocation.getContext()).getKubernetesClient();
            invocation.printf("Kubernetes %s.%s\n", client.getVersion().getMajor(), client.getVersion().getMinor());
        }
        return CommandResult.SUCCESS;
    }
}

