/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.rest;

import java.io.File;
import java.nio.file.NoSuchFileException;
import java.util.concurrent.CompletionStage;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.rest.RestCliCommand;
import org.infinispan.cli.completers.SchemaCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.logging.Messages;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.MediaType;

@GroupCommandDefinition(name="schema", description="Manipulates Protobuf schemas", activator=ConnectionActivator.class, groupCommands={Upload.class, Remove.class, Ls.class, Get.class})
public class Schema
extends CliCommand {
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(invocation.getHelpInfo());
        return CommandResult.FAILURE;
    }

    @CommandDefinition(name="get", description="Displays the Protobuf definition of a schema.")
    public static class Get
    extends RestCliCommand {
        @Argument(required=true, description="The name of the schema", completer=SchemaCompleter.class)
        String name;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, org.infinispan.cli.resources.Resource resource) {
            return client.schemas().get(this.name);
        }
    }

    @CommandDefinition(name="remove", aliases={"rm"}, description="Deletes Protobuf schema.")
    public static class Remove
    extends RestCliCommand {
        @Argument(required=true, description="The name of the schema", completer=SchemaCompleter.class)
        String name;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, org.infinispan.cli.resources.Resource resource) {
            return client.schemas().delete(this.name);
        }
    }

    @CommandDefinition(name="ls", description="Lists available Protobuf schemas.")
    public static class Ls
    extends RestCliCommand {
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, org.infinispan.cli.resources.Resource resource) {
            return client.schemas().names();
        }
    }

    @CommandDefinition(name="upload", description="Uploads Protobuf schemas to the server.")
    public static class Upload
    extends RestCliCommand {
        @Argument(required=true, description="The name of the schema")
        String name;
        @Option(completer=FileOptionCompleter.class, shortName=102, description="The Protobuf schema file to upload.", required=true)
        Resource file;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, org.infinispan.cli.resources.Resource resource) throws NoSuchFileException {
            if (this.file.exists()) {
                return client.schemas().put(this.name, RestEntity.create((MediaType)MediaType.TEXT_PLAIN, (File)new File(this.file.getAbsolutePath())));
            }
            throw Messages.MSG.nonExistentFile(this.file);
        }
    }
}

