/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.printers;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import org.infinispan.cli.printers.PrettyRowPrinter;

public class CacheEntryRowPrinter
implements PrettyRowPrinter {
    private final DateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private final int[] colWidths;

    public CacheEntryRowPrinter(int width, int columns) {
        this.colWidths = new int[columns];
        switch (columns) {
            case 1: {
                this.colWidths[0] = width;
                break;
            }
            case 2: {
                if (width <= 20) {
                    this.colWidths[0] = 6;
                    this.colWidths[1] = 13;
                    break;
                }
                this.colWidths[0] = Math.min(width / 3, 15);
                this.colWidths[1] = width - this.colWidths[0] - 1;
                break;
            }
            case 7: {
                if (width <= 80) {
                    this.colWidths[0] = 6;
                    this.colWidths[1] = 13;
                } else {
                    this.colWidths[0] = Math.min((width - 75) / 3, 15);
                    this.colWidths[1] = width - 75 - this.colWidths[0];
                }
                this.colWidths[2] = 6;
                this.colWidths[3] = 6;
                this.colWidths[4] = 19;
                this.colWidths[5] = 19;
                this.colWidths[6] = 19;
                break;
            }
        }
    }

    @Override
    public boolean showHeader() {
        return true;
    }

    @Override
    public String columnHeader(int column) {
        switch (column) {
            case 0: {
                return "Key";
            }
            case 1: {
                return "Value";
            }
            case 2: {
                return "TTL";
            }
            case 3: {
                return "Idle";
            }
            case 4: {
                return "Created";
            }
            case 5: {
                return "LastUsed";
            }
            case 6: {
                return "Expires";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int columnWidth(int column) {
        return this.colWidths[column];
    }

    @Override
    public String formatColumn(int column, String value) {
        if (column < 2) {
            return value;
        }
        long l = Long.parseLong(value);
        if (l < 0L) {
            return "\u221e";
        }
        if (column < 4) {
            return Duration.ofSeconds(l).toString().substring(2).toLowerCase();
        }
        return this.df.format(l);
    }
}

