/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.printers;

import java.io.Closeable;
import java.util.Iterator;
import java.util.Map;
import org.aesh.command.shell.Shell;
import org.infinispan.cli.printers.CsvPrettyPrinter;
import org.infinispan.cli.printers.JsonPrettyPrinter;
import org.infinispan.cli.printers.PrettyRowPrinter;
import org.infinispan.cli.printers.TablePrettyPrinter;

public interface PrettyPrinter
extends Closeable {
    public static PrettyPrinter forMode(PrettyPrintMode mode, Shell shell, PrettyRowPrinter rowPrinter) {
        switch (mode) {
            case TABLE: {
                return new TablePrettyPrinter(shell, rowPrinter);
            }
            case JSON: {
                return new JsonPrettyPrinter(shell);
            }
            case CSV: {
                return new CsvPrettyPrinter(shell, rowPrinter);
            }
        }
        throw new IllegalArgumentException(mode.name());
    }

    public void printItem(Map<String, String> var1);

    default public void print(Iterator<String> it) {
        it.forEachRemaining(i -> this.printItem(Map.of("", i)));
    }

    default public void print(Iterable<Map<String, String>> it) {
        it.forEach(this::printItem);
    }

    public static enum PrettyPrintMode {
        TABLE,
        JSON,
        CSV;

    }
}

