/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.kubernetes;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import java.util.Map;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.kubernetes.Kube;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.impl.KubernetesContext;
import org.infinispan.cli.logging.Messages;
import org.infinispan.commons.util.Version;

@CommandDefinition(name="uninstall", description="Removes the Operator.")
public class Uninstall
extends CliCommand {
    @Option(shortName=110, description="Specifies the namespace where the Operator is installed, if you did not install it globally.")
    String namespace;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        KubernetesClient client = KubernetesContext.getClient(invocation);
        if (this.namespace == null) {
            this.namespace = Kube.defaultOperatorNamespace(client);
        } else {
            ((Resource)((NonNamespaceOperation)client.genericKubernetesResources((ResourceDefinitionContext)Kube.OPERATOR_OPERATORGROUP_CRD).inNamespace(this.namespace)).withName(Version.getProperty((String)"infinispan.olm.name"))).delete();
        }
        Resource subscription = (Resource)((NonNamespaceOperation)client.genericKubernetesResources((ResourceDefinitionContext)Kube.OPERATOR_SUBSCRIPTION_CRD).inNamespace(this.namespace)).withName(Version.getProperty((String)"infinispan.olm.name"));
        GenericKubernetesResource sub = (GenericKubernetesResource)subscription.get();
        if (sub == null) {
            throw Messages.MSG.noOperatorSubscription(this.namespace);
        }
        Map status = (Map)sub.getAdditionalProperties().get("status");
        String csv = (String)status.get("installedCSV");
        boolean deleted = subscription.delete();
        if (deleted) {
            deleted = ((Resource)((NonNamespaceOperation)client.genericKubernetesResources((ResourceDefinitionContext)Kube.OPERATOR_CLUSTERSERVICEVERSION_CRD).inNamespace(this.namespace)).withName(csv)).delete();
            return deleted ? CommandResult.SUCCESS : CommandResult.FAILURE;
        }
        return CommandResult.FAILURE;
    }
}

