/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.rest;

import java.util.concurrent.CompletionStage;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.rest.RestCliCommand;
import org.infinispan.cli.completers.CacheCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.resources.CacheResource;
import org.infinispan.cli.resources.Resource;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;

@CommandDefinition(name="get", description="Gets an entry from the cache", activator=ConnectionActivator.class, aliases={"cat"})
public class Get
extends RestCliCommand {
    @Argument(required=true)
    String key;
    @Option(completer=CacheCompleter.class, shortName=99)
    String cache;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
        return client.cache(this.cache != null ? this.cache : CacheResource.cacheName(resource)).get(this.key);
    }
}

