/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.kubernetes;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.IOException;
import java.util.HashMap;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.kubernetes.Kube;
import org.infinispan.cli.completers.ExposeCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.impl.KubernetesContextImpl;

@GroupCommandDefinition(name="create", description="Creates a resource", groupCommands={Cluster.class})
public class Create
extends CliCommand {
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        return CommandResult.FAILURE;
    }

    @CommandDefinition(name="cluster", description="Creates a cluster")
    public static class Cluster
    extends CliCommand {
        @Option(shortName=110, description="Select the namespace")
        String namespace;
        @Option(shortName=114, description="The number of replicas", defaultValue={"1"})
        int replicas;
        @Option(name="expose-type", completer=ExposeCompleter.class)
        String exposeType;
        @Option(name="expose-port", defaultValue={"0"})
        int exposePort;
        @Option(name="expose-host")
        String exposeHost;
        @Argument(description="The name of the cluster to create", defaultValue={"infinispan"})
        String name;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            KubernetesClient client = ((KubernetesContextImpl)invocation.getContext()).getKubernetesClient();
            HashMap<String, Object> resource = new HashMap<String, Object>();
            Kube.add(resource, "apiVersion", "infinispan.org/v1");
            Kube.add(resource, "kind", "Infinispan");
            Kube.add(resource, "metadata.name", this.name);
            Kube.add(resource, "spec.replicas", this.replicas);
            if (this.exposeType != null) {
                Kube.add(resource, "spec.expose.type", this.exposeType);
            }
            if (this.exposeHost != null) {
                Kube.add(resource, "spec.expose.host", this.exposeHost);
            }
            if (this.exposePort > 0) {
                Kube.add(resource, "spec.expose.port", this.exposePort);
            }
            try {
                client.customResource(Kube.INFINISPAN_CLUSTER_CRD).create(Kube.getNamespaceOrDefault(client, this.namespace), resource);
                return CommandResult.SUCCESS;
            }
            catch (IOException e) {
                return CommandResult.SUCCESS;
            }
        }
    }
}

