/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.util;

import java.nio.file.Path;
import java.nio.file.Paths;

public class SystemUtils {
    public static String getAppConfigFolder(String appName) {
        Path configRoot = null;
        String osName = System.getProperty("os.name");
        if ("Mac OS X".equals(osName)) {
            configRoot = Paths.get(System.getProperty("user.home"), "Library", "Java");
        } else if (osName.startsWith("Windows")) {
            try {
                String appData = System.getenv("APPDATA");
                if (appData != null) {
                    configRoot = Paths.get(appData, new String[0]).resolve("Sun").resolve("Java");
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (configRoot == null) {
            configRoot = Paths.get(System.getProperty("user.home"), ".config");
        }
        return configRoot.resolve(appName).toString();
    }
}

