/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;

@CommandDefinition(name="connect", description="Connects to a remote server")
public class Connect
extends CliCommand {
    @Argument(description="The connection string 'http://<host>:<port>")
    String connectionString;
    @Option(shortName=117)
    String username;
    @Option(shortName=112)
    String password;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        if (this.username != null) {
            invocation.getContext().connect(invocation.getShell(), this.connectionString, this.username, this.password);
        } else {
            invocation.getContext().connect(invocation.getShell(), this.connectionString);
        }
        return invocation.getContext().isConnected() ? CommandResult.SUCCESS : CommandResult.FAILURE;
    }
}

