/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReaderIterator
implements Iterator<String>,
AutoCloseable {
    private final BufferedReader reader;
    private String line;
    private boolean eof = false;
    private final Pattern regex;
    private Matcher matcher;

    public ReaderIterator(InputStream inputStream) {
        this(inputStream, null);
    }

    public ReaderIterator(InputStream inputStream, Pattern regex) {
        Objects.nonNull(inputStream);
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.regex = regex;
    }

    public ReaderIterator(Reader reader, Pattern regex) {
        Objects.nonNull(reader);
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.regex = regex;
    }

    @Override
    public boolean hasNext() {
        if (this.eof) {
            return false;
        }
        if (this.line != null) {
            return true;
        }
        try {
            while (true) {
                String l;
                if (this.regex == null) {
                    l = this.reader.readLine();
                    if (l == null) {
                        this.close();
                        return false;
                    }
                    this.line = l;
                    return true;
                }
                if (this.matcher == null) {
                    l = this.reader.readLine();
                    if (l == null) {
                        this.close();
                        return false;
                    }
                    this.matcher = this.regex.matcher(l);
                }
                if (this.matcher.find()) {
                    this.line = this.matcher.group(1);
                    return true;
                }
                this.matcher = null;
            }
        }
        catch (IOException e) {
            this.close();
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String currentLine = this.line;
        this.line = null;
        return currentLine;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.eof = true;
        this.line = null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

