/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$processor$.encode.$Type;
import org.immutables.value.internal.$processor$.encode.$TypeExtractor;
import org.immutables.value.internal.$processor$.meta.$CriteriaMirror;
import org.immutables.value.internal.$processor$.meta.$MoreElements;
import org.immutables.value.internal.$processor$.meta.$MoreTypes;
import org.immutables.value.internal.$processor$.meta.$ValueAttribute;

public class $CriteriaModel {
    private static final String MATCHER = "org.immutables.criteria.matcher.Matcher";
    private static final Iterable<$Type.Defined> NO_BOUNDS = Collections.emptyList();
    private final $ValueAttribute attribute;
    private final $Type.Factory factory;
    private final Elements elements;
    private final Types types;
    private final IntrospectedType introspectedType;
    private final MatcherDefinition matcherDefinition;

    $CriteriaModel($ValueAttribute attribute) {
        this.attribute = $Preconditions.checkNotNull(attribute, "attribute");
        this.factory = new $Type.Producer();
        ProcessingEnvironment env = attribute.containingType.constitution.protoclass().environment().processing();
        this.elements = env.getElementUtils();
        this.types = env.getTypeUtils();
        this.introspectedType = new IntrospectedType(attribute.returnType, attribute.isNullable(), env.getTypeUtils(), env.getElementUtils());
        this.matcherDefinition = new MatcherDefinition(attribute, this.buildMatcher());
    }

    private $Type toType(TypeMirror mirror) {
        if (mirror.getKind() == TypeKind.ARRAY) {
            return this.factory.array(this.toType($MoreTypes.asArray(mirror).getComponentType()));
        }
        if (mirror.getKind().isPrimitive()) {
            TypeElement boxed = this.types.boxedClass($MoreTypes.asPrimitiveType(mirror));
            return this.factory.reference(boxed.getQualifiedName().toString());
        }
        Element element = this.types.asElement(mirror);
        if (element == null) {
            throw new IllegalArgumentException(String.format("Element for type %s not found (attribute %s %s)", mirror, this.attribute.name(), this.attribute.returnType));
        }
        $TypeExtractor extractor = new $TypeExtractor(this.factory, $MoreElements.asType(element));
        return extractor.get(mirror);
    }

    private static String topLevelCriteriaClassName(TypeMirror type) {
        DeclaredType declaredType = $MoreTypes.asDeclared(type);
        Element element = declaredType.asElement();
        while ((element = element.getEnclosingElement()).getKind() != ElementKind.PACKAGE) {
        }
        String packagePrefix = "";
        if (!element.getSimpleName().contentEquals("")) {
            packagePrefix = $MoreElements.asPackage(element).getQualifiedName() + ".";
        }
        return packagePrefix + declaredType.asElement().getSimpleName().toString() + "CriteriaTemplate";
    }

    private $Type.Parameterized matcherType(IntrospectedType introspected) {
        $Type.Parameterized matcherType;
        IntrospectedType param;
        TypeMirror type = introspected.type;
        String name = introspected.useOptional() ? ((param = introspected.optionalParameter()).isString() ? "org.immutables.criteria.matcher.OptionalStringMatcher.Template" : (param.isBoolean() ? "org.immutables.criteria.matcher.OptionalBooleanMatcher.Template" : (param.isNumber() ? (param.isInteger() ? "org.immutables.criteria.matcher.OptionalIntegerMatcher.Template" : (param.isLong() ? "org.immutables.criteria.matcher.OptionalLongMatcher.Template" : (param.isDouble() ? "org.immutables.criteria.matcher.OptionalDoubleMatcher.Template" : (param.isBigInteger() ? "org.immutables.criteria.matcher.OptionalBigIntegerMatcher.Template" : (param.isBigDecimal() ? "org.immutables.criteria.matcher.OptionalBigDecimalMatcher.Template" : "org.immutables.criteria.matcher.OptionalNumberMatcher.Template"))))) : (param.isComparable() ? "org.immutables.criteria.matcher.OptionalComparableMatcher.Template" : "org.immutables.criteria.matcher.OptionalObjectMatcher.Template")))) : (introspected.hasCriteria() ? $CriteriaModel.topLevelCriteriaClassName(type) : (introspected.isBoolean() ? "org.immutables.criteria.matcher.BooleanMatcher.Template" : (introspected.isNumber() ? (introspected.isInteger() ? "org.immutables.criteria.matcher.IntegerMatcher.Template" : (introspected.isLong() ? "org.immutables.criteria.matcher.LongMatcher.Template" : (introspected.isDouble() ? "org.immutables.criteria.matcher.DoubleMatcher.Template" : (introspected.isBigInteger() ? "org.immutables.criteria.matcher.BigIntegerMatcher.Template" : (introspected.isBigDecimal() ? "org.immutables.criteria.matcher.BigDecimalMatcher.Template" : "org.immutables.criteria.matcher.NumberMatcher.Template"))))) : (introspected.isString() ? "org.immutables.criteria.matcher.StringMatcher.Template" : (introspected.isIterable() || introspected.isArray() ? "org.immutables.criteria.matcher.IterableMatcher.Template" : (introspected.isComparable() ? "org.immutables.criteria.matcher.ComparableMatcher.Template" : "org.immutables.criteria.matcher.ObjectMatcher.Template"))))));
        TypeElement element = this.elements.getTypeElement(name);
        if (element == null) {
            $Type.Variable variable = this.factory.parameters().introduce("R", NO_BOUNDS).variable("R");
            matcherType = this.factory.parameterized(this.factory.reference(name), Collections.singleton(variable));
        } else {
            matcherType = ($Type.Parameterized)this.toType(element.asType());
        }
        return matcherType;
    }

    public $Type.Parameterized buildMatcher() {
        return this.buildMatcher(this.introspectedType);
    }

    private $Type.Parameterized buildMatcher(IntrospectedType introspected) {
        $Preconditions.checkNotNull(introspected, introspected);
        TypeMirror type = introspected.type;
        $Type.Parameterized matcher = this.matcherType(introspected);
        if (matcher.arguments.size() > 1) {
            TypeMirror mirror;
            $Type valueType;
            $Type.VariableResolver resolver = $Type.VariableResolver.empty();
            $Type.Variable arg1 = ($Type.Variable)matcher.arguments.get(1);
            for ($Type.Nonprimitive arg : matcher.arguments) {
                if (!(arg instanceof $Type.Variable) || !(($Type.Variable)arg).name.equals("P")) continue;
                resolver = resolver.bind(($Type.Variable)arg, this.factory.reference(type.toString()));
            }
            if (introspected.useOptional()) {
                IntrospectedType newType = introspected.optionalParameter();
                valueType = this.toType(newType.type());
                resolver = newType.hasOptionalMatcher() ? resolver.bind(arg1, ($Type.Nonprimitive)valueType) : resolver.bind(arg1, this.buildMatcher(newType));
            } else if (introspected.isScalar()) {
                valueType = this.toType(introspected.box());
                resolver = resolver.bind(arg1, ($Type.Nonprimitive)valueType);
            } else if (introspected.isArray()) {
                mirror = $MoreTypes.asArray(type).getComponentType();
                valueType = this.toType(mirror);
                resolver = resolver.bind(arg1, this.buildMatcher(introspected.withType(mirror)));
            } else {
                mirror = $MoreTypes.asDeclared(type).getTypeArguments().get(0);
                valueType = this.toType(mirror);
                resolver = resolver.bind(arg1, this.buildMatcher(introspected.withType(mirror)));
            }
            if (matcher.arguments.size() > 2 && (($Type.Variable)matcher.arguments.get((int)2)).name.equals("V")) {
                resolver = resolver.bind(($Type.Variable)matcher.arguments.get(2), ($Type.Nonprimitive)valueType);
            }
            if (introspected.isArray() || introspected.isIterable()) {
                for ($Type.Nonprimitive arg : matcher.arguments) {
                    if (!(arg instanceof $Type.Variable) || !(($Type.Variable)arg).name.equals("P")) continue;
                    resolver = resolver.bind(($Type.Variable)arg, this.factory.reference(type.toString()));
                }
            }
            return ($Type.Parameterized)matcher.accept(resolver);
        }
        return matcher;
    }

    public MatcherDefinition matcher() {
        return this.matcherDefinition;
    }

    private static class IntrospectedType {
        private final TypeMirror type;
        private final Types types;
        private final Elements elements;
        private final boolean nullable;
        private final TypeMirror erasure;

        IntrospectedType(TypeMirror type, boolean nullable, Types types, Elements elements) {
            this.types = types;
            this.elements = elements;
            this.type = $Preconditions.checkNotNull(type, "type");
            this.nullable = nullable;
            TypeMirror erasure = types.erasure(type);
            if (erasure.getKind().isPrimitive()) {
                erasure = types.boxedClass($MoreTypes.asPrimitiveType(erasure)).asType();
            }
            this.erasure = erasure;
        }

        public TypeMirror type() {
            return this.type;
        }

        public IntrospectedType withType(TypeMirror type) {
            return new IntrospectedType(type, false, this.types, this.elements);
        }

        private boolean isSubtypeOf(Class<?> maybeSuper) {
            Objects.requireNonNull(maybeSuper, "maybeSuper");
            return this.isSubtypeOf(this.elements.getTypeElement(maybeSuper.getCanonicalName()));
        }

        private boolean isSubtypeOf(Element element) {
            Objects.requireNonNull(element, "element");
            TypeMirror maybeSuperType = element.asType();
            return this.types.isSubtype(this.erasure, this.types.erasure(maybeSuperType));
        }

        public boolean isBoolean() {
            return this.type.getKind() == TypeKind.BOOLEAN || this.isSubtypeOf(Boolean.class);
        }

        public boolean isNumber() {
            return this.type.getKind().isPrimitive() && !this.isBoolean() && this.type.getKind() != TypeKind.CHAR || this.isSubtypeOf(Number.class);
        }

        public boolean isInteger() {
            return this.type.getKind() == TypeKind.INT || this.isSubtypeOf(Integer.class);
        }

        public boolean isLong() {
            return this.type.getKind() == TypeKind.LONG || this.isSubtypeOf(Long.class);
        }

        public boolean isDouble() {
            return this.type.getKind() == TypeKind.DOUBLE || this.isSubtypeOf(Double.class);
        }

        public boolean isBigInteger() {
            return this.isSubtypeOf(BigInteger.class);
        }

        public boolean isBigDecimal() {
            return this.isSubtypeOf(BigDecimal.class);
        }

        public boolean isContainer() {
            return this.isIterable() || this.isOptional() || this.isArray() || this.isMap();
        }

        public boolean isScalar() {
            return !this.isContainer();
        }

        public boolean isEnum() {
            return this.types.asElement(this.type).getKind() == ElementKind.ENUM;
        }

        public boolean isIterable() {
            return this.isSubtypeOf(Iterable.class);
        }

        public boolean isArray() {
            return this.type.getKind() == TypeKind.ARRAY;
        }

        public boolean hasOptionalMatcher() {
            return this.isString() || this.isComparable() || this.isBoolean() || this.isNumber();
        }

        public boolean isComparable() {
            return this.isSubtypeOf(Comparable.class);
        }

        public boolean isString() {
            return this.isSubtypeOf(String.class);
        }

        public boolean isMap() {
            return this.isSubtypeOf(Map.class);
        }

        public boolean isMatcher() {
            return this.isSubtypeOf(this.elements.getTypeElement($CriteriaModel.MATCHER));
        }

        public TypeMirror box() {
            return this.type.getKind().isPrimitive() ? this.types.boxedClass($MoreTypes.asPrimitiveType(this.type)).asType() : this.type;
        }

        public boolean hasCriteria() {
            Element element = this.types.asElement(this.type);
            return element != null && $CriteriaMirror.find(element).isPresent();
        }

        private IntrospectedType optionalParameter() {
            TypeMirror newType;
            if (this.isNullable()) {
                return this.withType(this.type);
            }
            String typeName = this.erasure.toString();
            if ("java.util.OptionalInt".equals(typeName)) {
                newType = this.elements.getTypeElement(Integer.class.getName()).asType();
            } else if ("java.util.OptionalLong".equals(typeName)) {
                newType = this.elements.getTypeElement(Long.class.getName()).asType();
            } else if ("java.util.OptionalDouble".equals(typeName)) {
                newType = this.elements.getTypeElement(Double.class.getName()).asType();
            } else if ("java.util.Optional".equals(typeName) || "org.immutables.value.internal.$guava$.base.$Optional".equals(typeName) || "io.atlassian.fugue.Option".equals(typeName)) {
                newType = $MoreTypes.asDeclared(this.type).getTypeArguments().get(0);
            } else {
                throw new IllegalArgumentException(String.format("%s is not an optional type", this.type));
            }
            return this.withType(newType);
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean useOptional() {
            return this.isOptional() || this.isNullable();
        }

        public boolean isOptional() {
            List<String> names = Arrays.asList("java.util.Optional", "java.util.OptionalInt", "java.util.OptionalDouble", "java.util.OptionalLong", $Optional.class.getName(), "io.atlassian.fugue.Option");
            for (String name : names) {
                TypeElement element = this.elements.getTypeElement(name);
                if (element == null || !this.isSubtypeOf(element)) continue;
                return true;
            }
            return false;
        }
    }

    public static class MatcherDefinition {
        private final $ValueAttribute attribute;
        private final $Type.Parameterized matcherType;
        private final MatcherDef def;

        private MatcherDefinition($ValueAttribute attribute, $Type.Parameterized matcherType) {
            this.attribute = attribute;
            this.matcherType = $Preconditions.checkNotNull(matcherType, "type");
            ProcessingEnvironment env = attribute.containingType.constitution.protoclass().environment().processing();
            this.def = matcherType.accept(new CreatorVisitor(env.getTypeUtils(), env.getElementUtils(), attribute));
        }

        public $Type.Parameterized matcherType() {
            return this.matcherType;
        }

        public String creator() {
            String first = this.def.creator;
            String second = this.def instanceof ContainerDef ? ((ContainerDef)this.def).element.creator : first;
            String withPath = String.format("context.appendPath(%s.class, \"%s\", %s)", this.attribute.containingType.typeDocument().toString(), this.attribute.originalElement().getSimpleName().toString(), second);
            return String.format("%s.create(%s)", first, withPath);
        }
    }

    private static class MatcherDef {
        public final $Type.Defined type;
        public final String creator;

        private MatcherDef($Type.Defined type, String creator) {
            this.type = Objects.requireNonNull(type, "type");
            this.creator = creator;
        }
    }

    private static class ContainerDef
    extends MatcherDef {
        public final MatcherDef element;

        private ContainerDef($Type.Defined type, MatcherDef element, String creator) {
            super(type, creator);
            this.element = Objects.requireNonNull(element, "element");
        }
    }

    private static class CreatorVisitor
    implements $Type.Visitor<MatcherDef> {
        private final Types types;
        private final Elements elements;
        private final $ValueAttribute attribute;

        private CreatorVisitor(Types types, Elements elements, $ValueAttribute attribute) {
            this.types = types;
            this.elements = elements;
            this.attribute = attribute;
        }

        @Override
        public MatcherDef primitive($Type.Primitive primitive) {
            throw new AssertionError();
        }

        @Override
        public MatcherDef reference($Type.Reference reference) {
            return new MatcherDef(reference, this.creator(reference));
        }

        private String creator($Type.Reference reference) {
            if (this.isMatcher(reference)) {
                String name = reference.name;
                if (name.endsWith(".Template")) {
                    name = name.substring(0, name.lastIndexOf(".Template"));
                }
                if (this.attribute.hasCriteria() && name.endsWith("Template")) {
                    name = name.substring(0, name.lastIndexOf("Template"));
                }
                return name + ".creator()";
            }
            return "org.immutables.criteria.matcher.ObjectMatcher.creator()";
        }

        @Override
        public MatcherDef parameterized($Type.Parameterized parameterized) {
            for ($Type.Nonprimitive arg : parameterized.arguments) {
                if (!(arg instanceof $Type.Parameterized)) continue;
                $Type.Parameterized param = ($Type.Parameterized)arg;
                if (!this.isMatcher(param.reference)) continue;
                return new ContainerDef(parameterized.reference, param.accept(this), this.creator(parameterized.reference));
            }
            return this.reference(parameterized.reference);
        }

        private boolean isMatcher($Type.Reference reference) {
            TypeElement element = this.elements.getTypeElement(reference.name);
            if (element != null && this.types.isSubtype(element.asType(), this.elements.getTypeElement($CriteriaModel.MATCHER).asType())) {
                return true;
            }
            return this.attribute.hasCriteria();
        }

        @Override
        public MatcherDef variable($Type.Variable variable) {
            throw new AssertionError();
        }

        @Override
        public MatcherDef array($Type.Array array) {
            throw new AssertionError();
        }

        @Override
        public MatcherDef superWildcard($Type.Wildcard.Super wildcard) {
            throw new AssertionError();
        }

        @Override
        public MatcherDef extendsWildcard($Type.Wildcard.Extends wildcard) {
            throw new AssertionError();
        }
    }
}

