/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.immutables.value.internal.$guava$.base.$MoreObjects;
import org.immutables.value.internal.$guava$.collect.$ImmutableMap;
import org.immutables.value.internal.$processor$.meta.$CustomImmutableCollections;
import org.immutables.value.internal.$processor$.meta.$UnshadeGuava;

public enum $AttributeTypeKind {
    REGULAR("", new String[0]),
    ENCODING("", new String[0]),
    ARRAY("", new String[0]),
    LIST("List", List.class.getName(), $UnshadeGuava.qualify("collect.ImmutableList")),
    SET("Set", Set.class.getName(), $UnshadeGuava.qualify("collect.ImmutableSet")),
    ENUM_SET("Set", new String[0]),
    SORTED_SET("SortedSet", SortedSet.class.getName(), NavigableSet.class.getName(), $UnshadeGuava.qualify("collect.ImmutableSortedSet")),
    MAP("Map", Map.class.getName(), $UnshadeGuava.qualify("collect.ImmutableMap")),
    ENUM_MAP("Map", new String[0]),
    SORTED_MAP("SortedMap", SortedMap.class.getName(), NavigableMap.class.getName(), $UnshadeGuava.qualify("collect.ImmutableSortedMap")),
    MULTISET("Multiset", $UnshadeGuava.qualify("collect.Multiset"), $UnshadeGuava.qualify("collect.ImmutableMultiset")),
    SORTED_MULTISET("SortedMultiset", $UnshadeGuava.qualify("collect.SortedMultiset"), $UnshadeGuava.qualify("collect.ImmutableSortedMultiset")),
    MULTIMAP("Multimap", $UnshadeGuava.qualify("collect.Multimap"), $UnshadeGuava.qualify("collect.ImmutableMultimap")),
    LIST_MULTIMAP("ListMultimap", $UnshadeGuava.qualify("collect.ListMultimap"), $UnshadeGuava.qualify("collect.ImmutableListMultimap")),
    SET_MULTIMAP("SetMultimap", $UnshadeGuava.qualify("collect.SetMultimap"), $UnshadeGuava.qualify("collect.ImmutableSetMultimap")),
    BI_MAP("BiMap", $UnshadeGuava.qualify("collect.BiMap"), $UnshadeGuava.qualify("collect.ImmutableBiMap")),
    OPTIONAL_JDK("Optional", "java.util.Optional"),
    OPTIONAL_INT_JDK("OptionalInt", "java.util.OptionalInt"),
    OPTIONAL_LONG_JDK("OptionalLong", "java.util.OptionalLong"),
    OPTIONAL_DOUBLE_JDK("OptionalDouble", "java.util.OptionalDouble"),
    OPTIONAL_GUAVA("Optional", $UnshadeGuava.qualify("base.Optional")),
    OPTION_FUGUE("Option", "com.atlassian.fugue.Option", "io.atlassian.fugue.Option"),
    OPTION_JAVASLANG("Option", "javaslang.control.Option"),
    CUSTOM_COLLECTION("", "");

    private final String[] rawTypes;
    private final String rawSimpleName;
    private static final $ImmutableMap<String, $AttributeTypeKind> rawTypeMapping;

    private $AttributeTypeKind(String rawSimpleName, String ... rawTypes) {
        this.rawSimpleName = rawSimpleName;
        this.rawTypes = rawTypes;
    }

    public String rawSimpleName(String rawType) {
        if (this.isCustomCollection()) {
            int lastDot = rawType.lastIndexOf(46);
            return lastDot < 0 ? rawType : rawType.substring(lastDot + 1);
        }
        return this.rawSimpleName;
    }

    static $AttributeTypeKind forRawType(String rawType) {
        return $MoreObjects.firstNonNull(rawTypeMapping.get(rawType), REGULAR);
    }

    $AttributeTypeKind havingEnumFirstTypeParameter(boolean isEnum) {
        if (isEnum) {
            switch (this.ordinal()) {
                case 4: {
                    return ENUM_SET;
                }
                case 7: {
                    return ENUM_MAP;
                }
            }
        }
        return this;
    }

    public boolean isSortedKind() {
        switch (this.ordinal()) {
            case 6: 
            case 9: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public boolean isSetKind() {
        switch (this.ordinal()) {
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public boolean isContainerKind() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return false;
            }
        }
        return true;
    }

    public boolean isCollectionKind() {
        switch (this.ordinal()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    public boolean isMapKind() {
        switch (this.ordinal()) {
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    public boolean isMappingKind() {
        switch (this.ordinal()) {
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    public boolean isKeyedKind() {
        return this.isMappingKind() || this.isSetKind();
    }

    public boolean isJdkOnlyContainerKind() {
        switch (this.ordinal()) {
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    public boolean isGuavaContainerKind() {
        switch (this.ordinal()) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    public boolean isOptionalJdk() {
        return this == OPTIONAL_JDK;
    }

    public boolean isOptionalSpecializedJdk() {
        switch (this.ordinal()) {
            case 17: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    public boolean isOptionalGuava() {
        return this == OPTIONAL_GUAVA;
    }

    public boolean isOptionFugue() {
        return this == OPTION_FUGUE;
    }

    public boolean isOptionJavaslang() {
        return this == OPTION_JAVASLANG;
    }

    public boolean isOptionalKind() {
        switch (this.ordinal()) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return true;
            }
        }
        return false;
    }

    public boolean isEnumKeyed() {
        switch (this.ordinal()) {
            case 5: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public boolean isCollectionOrMapping() {
        return this.isCollectionKind() || this.isMappingKind();
    }

    public boolean isMultisetKind() {
        switch (this.ordinal()) {
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public boolean isMultimapKind() {
        switch (this.ordinal()) {
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public boolean isCustomCollection() {
        return this == CUSTOM_COLLECTION;
    }

    public boolean isSet() {
        return this == SET;
    }

    public boolean isEnumSet() {
        return this == ENUM_SET;
    }

    public boolean isSortedSet() {
        return this == SORTED_SET;
    }

    public boolean isList() {
        return this == LIST;
    }

    public boolean isMap() {
        return this == MAP;
    }

    public boolean isPlainMapKind() {
        return this == MAP || this == ENUM_MAP;
    }

    public boolean isBiMap() {
        return this == BI_MAP;
    }

    public boolean isSortedMap() {
        return this == SORTED_MAP;
    }

    public boolean isArray() {
        return this == ARRAY;
    }

    public boolean isRegular() {
        return this == REGULAR;
    }

    public boolean isEncoding() {
        return this == ENCODING;
    }

    public boolean isMultiset() {
        return this == MULTISET;
    }

    public boolean isSortedMultiset() {
        return this == SORTED_MULTISET;
    }

    public boolean isMultimap() {
        return this == MULTIMAP;
    }

    public boolean isSetMultimap() {
        return this == SET_MULTIMAP;
    }

    public boolean isListMultimap() {
        return this == LIST_MULTIMAP;
    }

    public boolean isEnumMap() {
        return this == ENUM_MAP;
    }

    static {
        $ImmutableMap.Builder<String, $AttributeTypeKind> builder = $ImmutableMap.builder();
        for ($AttributeTypeKind k : $AttributeTypeKind.values()) {
            if (k.isCustomCollection()) {
                for (String c : $CustomImmutableCollections.collections()) {
                    builder.put(c, k);
                }
                continue;
            }
            for (String r : k.rawTypes) {
                builder.put(r, k);
            }
        }
        rawTypeMapping = builder.build();
    }
}

