package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AttributeBuilderReflection.FirstPartyStrategy}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableFirstPartyStrategy.of()}.
 */
@Generated(from = "AttributeBuilderReflection.FirstPartyStrategy", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableFirstPartyStrategy
    extends AttributeBuilderReflection.FirstPartyStrategy {
  private final ValueAttribute valueAttribute;

  private ImmutableFirstPartyStrategy(ValueAttribute valueAttribute) {
    this.valueAttribute = Objects.requireNonNull(valueAttribute, "valueAttribute");
  }

  private ImmutableFirstPartyStrategy(
      ImmutableFirstPartyStrategy original,
      ValueAttribute valueAttribute) {
    this.valueAttribute = valueAttribute;
  }

  /**
   * @return The value of the {@code valueAttribute} attribute
   */
  @Override
  ValueAttribute valueAttribute() {
    return valueAttribute;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AttributeBuilderReflection.FirstPartyStrategy#valueAttribute() valueAttribute} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueAttribute
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFirstPartyStrategy withValueAttribute(ValueAttribute value) {
    if (this.valueAttribute == value) return this;
    ValueAttribute newValue = Objects.requireNonNull(value, "valueAttribute");
    return new ImmutableFirstPartyStrategy(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFirstPartyStrategy} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFirstPartyStrategy
        && equalTo((ImmutableFirstPartyStrategy) another);
  }

  private boolean equalTo(ImmutableFirstPartyStrategy another) {
    return valueAttribute.equals(another.valueAttribute);
  }

  /**
   * Computes a hash code from attributes: {@code valueAttribute}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + valueAttribute.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FirstPartyStrategy} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FirstPartyStrategy")
        .omitNullValues()
        .add("valueAttribute", valueAttribute)
        .toString();
  }

  /**
   * Construct a new immutable {@code FirstPartyStrategy} instance.
   * @param valueAttribute The value for the {@code valueAttribute} attribute
   * @return An immutable FirstPartyStrategy instance
   */
  public static ImmutableFirstPartyStrategy of(ValueAttribute valueAttribute) {
    return new ImmutableFirstPartyStrategy(valueAttribute);
  }

  /**
   * Creates an immutable copy of a {@link AttributeBuilderReflection.FirstPartyStrategy} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FirstPartyStrategy instance
   */
  public static ImmutableFirstPartyStrategy copyOf(AttributeBuilderReflection.FirstPartyStrategy instance) {
    if (instance instanceof ImmutableFirstPartyStrategy) {
      return (ImmutableFirstPartyStrategy) instance;
    }
    return ImmutableFirstPartyStrategy.of(instance.valueAttribute());
  }
}
