/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.eclipse.jdt.internal.compiler.apt.model.ElementImpl;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.immutables.generator.Compiler;

public final class SourceOrdering {
    private static final OrderingProvider DEFAULT_PROVIDER = new OrderingProvider(){

        @Override
        public Ordering<Element> enclosedBy(Element element) {
            return Ordering.explicit(element.getEnclosedElements());
        }
    };
    private static final OrderingProvider PROVIDER = SourceOrdering.createProvider();

    private SourceOrdering() {
    }

    public static ImmutableList<Element> getEnclosedElements(Element element) {
        return SourceOrdering.enclosedBy(element).immutableSortedCopy(element.getEnclosedElements());
    }

    public static Ordering<Element> enclosedBy(Element element) {
        return PROVIDER.enclosedBy(element);
    }

    private static OrderingProvider createProvider() {
        if (Compiler.ECJ.isPresent()) {
            return new EclipseCompilerOrderingProvider();
        }
        return DEFAULT_PROVIDER;
    }

    public static AccessorProvider getAllAccessorsProvider(Elements elements, Types types, TypeElement originatingType) {
        class CollectedOrdering
        extends Ordering<Element> {
            final Map<String, 1CollectedOrdering.Intratype> accessorOrderings = new LinkedHashMap<String, 1CollectedOrdering.Intratype>();
            final Set<TypeElement> linearizedTypes = new LinkedHashSet<TypeElement>();
            final ArrayListMultimap<String, TypeElement> accessorMapping = ArrayListMultimap.create();
            final /* synthetic */ TypeElement val$originatingType;

            CollectedOrdering(TypeElement typeElement) {
                this.val$originatingType = typeElement;
                this.traverse(this.val$originatingType);
                this.collectAccessors();
            }

            void traverse(@Nullable TypeElement element) {
                if (element == null || SourceOrdering.isJavaLangObject(element)) {
                    return;
                }
                for (TypeMirror typeMirror : element.getInterfaces()) {
                    this.traverse(this.toElement(typeMirror));
                }
                if (element.getKind().isClass()) {
                    this.traverse(this.toElement(element.getSuperclass()));
                }
                this.linearizedTypes.add(element);
            }

            @Nullable
            TypeElement toElement(TypeMirror type) {
                if (type.getKind() == TypeKind.DECLARED) {
                    return (TypeElement)((DeclaredType)type).asElement();
                }
                return null;
            }

            void collectAccessors() {
                int i = 0;
                for (TypeElement type : this.linearizedTypes) {
                    ImmutableList accessorsInType = FluentIterable.from(SourceOrdering.getEnclosedElements(type)).filter((Predicate)IsParameterlessNonstaticNonobject.PREDICATE).transform((Function)ToSimpleName.FUNCTION).toList();
                    String typeTag = type.getSimpleName().toString();
                    1CollectedOrdering.Intratype intratype = new 1CollectedOrdering.Intratype(typeTag, i++, (List<String>)accessorsInType);
                    for (String name : accessorsInType) {
                        this.accessorMapping.put((Object)name, (Object)type);
                        this.accessorOrderings.put(name, intratype);
                    }
                }
            }

            public int compare(Element left, Element right) {
                1CollectedOrdering.Intratype rightIntratype;
                String leftKey = ToSimpleName.FUNCTION.apply(left);
                String rightKey = ToSimpleName.FUNCTION.apply(right);
                1CollectedOrdering.Intratype leftIntratype = this.accessorOrderings.get(leftKey);
                return leftIntratype == (rightIntratype = this.accessorOrderings.get(rightKey)) ? leftIntratype.ordering.compare((Object)leftKey, (Object)rightKey) : Integer.compare(leftIntratype.rank, rightIntratype.rank);
            }

            class 1CollectedOrdering.Intratype {
                final String inType;
                final Ordering<String> ordering;
                final int rank;

                1CollectedOrdering.Intratype(String inType, int rank, List<String> accessors) {
                    this.inType = inType;
                    this.rank = rank;
                    this.ordering = Ordering.explicit(accessors);
                }

                public String toString() {
                    return "(<=> " + this.inType + ", " + this.rank + ", " + this.ordering + ")";
                }
            }
        }
        final CollectedOrdering ordering = new CollectedOrdering(originatingType);
        final ImmutableList sortedList = ordering.immutableSortedCopy(SourceOrdering.disambiguateMethods(ElementFilter.methodsIn(elements.getAllMembers(originatingType))));
        return new AccessorProvider(){
            ImmutableListMultimap<String, TypeElement> accessorMapping;
            {
                this.accessorMapping = ImmutableListMultimap.copyOf(ordering.accessorMapping);
            }

            @Override
            public ImmutableListMultimap<String, TypeElement> accessorMapping() {
                return this.accessorMapping;
            }

            @Override
            public ImmutableList<ExecutableElement> get() {
                return sortedList;
            }
        };
    }

    private static List<ExecutableElement> disambiguateMethods(Iterable<? extends ExecutableElement> methods) {
        HashMultimap methodsAlternatives = HashMultimap.create();
        for (ExecutableElement executableElement : methods) {
            if (!IsParameterlessNonstaticNonobject.PREDICATE.apply(executableElement)) continue;
            methodsAlternatives.put((Object)ToSimpleName.FUNCTION.apply(executableElement), (Object)executableElement);
        }
        ArrayList resolvedMethods = Lists.newArrayList();
        block1: for (Map.Entry e : methodsAlternatives.asMap().entrySet()) {
            Collection values = (Collection)e.getValue();
            if (values.size() == 1) {
                resolvedMethods.addAll(values);
                continue;
            }
            for (ExecutableElement v2 : values) {
                if (!v2.getEnclosingElement().getKind().isClass()) continue;
                resolvedMethods.add(v2);
                continue block1;
            }
            Iterator iterator = values.iterator();
            if (!iterator.hasNext()) continue;
            ExecutableElement v = (ExecutableElement)iterator.next();
            resolvedMethods.add(v);
        }
        return resolvedMethods;
    }

    static boolean isJavaLangObject(TypeElement element) {
        return element.getQualifiedName().contentEquals(Object.class.getName());
    }

    private static enum IsParameterlessNonstaticNonobject implements Predicate<Element>
    {
        PREDICATE;


        public boolean apply(Element input) {
            if (input.getKind() != ElementKind.METHOD) {
                return false;
            }
            if (SourceOrdering.isJavaLangObject((TypeElement)input.getEnclosingElement())) {
                return false;
            }
            ExecutableElement element = (ExecutableElement)input;
            boolean parameterless = element.getParameters().isEmpty();
            boolean nonstatic = !element.getModifiers().contains((Object)Modifier.STATIC);
            return parameterless && nonstatic;
        }
    }

    private static enum ToSimpleName implements Function<Element, String>
    {
        FUNCTION;


        public String apply(Element input) {
            return input.getSimpleName().toString();
        }
    }

    public static interface AccessorProvider {
        public ImmutableListMultimap<String, TypeElement> accessorMapping();

        public ImmutableList<ExecutableElement> get();
    }

    private static class EclipseCompilerOrderingProvider
    implements OrderingProvider,
    Function<Element, Object> {
        private EclipseCompilerOrderingProvider() {
        }

        public Object apply(Element input) {
            return ((ElementImpl)input)._binding;
        }

        @Override
        public Ordering<Element> enclosedBy(Element element) {
            if (element instanceof ElementImpl && Iterables.all(element.getEnclosedElements(), (Predicate)Predicates.instanceOf(ElementImpl.class))) {
                ElementImpl implementation = (ElementImpl)element;
                if (implementation._binding instanceof SourceTypeBinding) {
                    SourceTypeBinding sourceBinding = (SourceTypeBinding)implementation._binding;
                    return Ordering.natural().onResultOf(Functions.compose(this.bindingsToSourceOrder(sourceBinding), (Function)this));
                }
            }
            return DEFAULT_PROVIDER.enclosedBy(element);
        }

        private Function<Object, Integer> bindingsToSourceOrder(SourceTypeBinding sourceBinding) {
            IdentityHashMap bindings = Maps.newIdentityHashMap();
            if (sourceBinding.scope.referenceContext.methods != null) {
                for (AbstractMethodDeclaration abstractMethodDeclaration : sourceBinding.scope.referenceContext.methods) {
                    bindings.put(abstractMethodDeclaration.binding, abstractMethodDeclaration.declarationSourceStart);
                }
            }
            if (sourceBinding.scope.referenceContext.fields != null) {
                for (AbstractMethodDeclaration abstractMethodDeclaration : sourceBinding.scope.referenceContext.fields) {
                    bindings.put(abstractMethodDeclaration.binding, abstractMethodDeclaration.declarationSourceStart);
                }
            }
            if (sourceBinding.scope.referenceContext.memberTypes != null) {
                for (AbstractMethodDeclaration abstractMethodDeclaration : sourceBinding.scope.referenceContext.memberTypes) {
                    bindings.put(abstractMethodDeclaration.binding, abstractMethodDeclaration.declarationSourceStart);
                }
            }
            return Functions.forMap((Map)bindings);
        }
    }

    private static interface OrderingProvider {
        public Ordering<Element> enclosedBy(Element var1);
    }
}

