/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.data;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;

public interface Datatype<T> {
    public String name();

    public TypeToken<T> type();

    public boolean isInline();

    public List<Feature<T, ?>> features();

    public <F> F get(Feature<T, F> var1, T var2);

    public boolean isInstantiable();

    default public Set<Datatype<? extends T>> cases() {
        return ImmutableSet.of();
    }

    public Builder<T> builder();

    default public Feature<T, ?> feature(String name) {
        for (Feature<T, ?> f : this.features()) {
            if (!f.name().equals(name)) continue;
            return f;
        }
        throw new NoSuchElementException(name);
    }

    default public <F> Feature<T, F> feature(String name, TypeToken<F> type) {
        for (Feature<T, ?> f : this.features()) {
            if (!f.name().equals(name) || !f.type().equals(type)) continue;
            return f;
        }
        throw new NoSuchElementException(name + ": " + type);
    }

    public static interface Feature<T, F> {
        public int index();

        public boolean nullable();

        public String name();

        public TypeToken<F> type();

        public boolean supportsInput();

        public boolean supportsOutput();

        public boolean omittableOnInput();

        public boolean ignorableOnOutput();

        public static <T, F> Feature<T, F> of(final int index, final String owner, final String name, final TypeToken<F> type, final boolean nullable, final boolean setter, final boolean getter, final boolean omittable, final boolean ignorable) {
            return new Feature<T, F>(){

                @Override
                public int index() {
                    return index;
                }

                @Override
                public boolean nullable() {
                    return nullable;
                }

                @Override
                public String name() {
                    return name;
                }

                @Override
                public TypeToken<F> type() {
                    return type;
                }

                @Override
                public boolean supportsInput() {
                    return setter;
                }

                @Override
                public boolean supportsOutput() {
                    return getter;
                }

                @Override
                public boolean omittableOnInput() {
                    return omittable;
                }

                @Override
                public boolean ignorableOnOutput() {
                    return ignorable;
                }

                public String toString() {
                    return String.format("%s.%s: %s%s(getter:%s,setter:%s,omittable:%s,ignorable:%s", owner, name, type, nullable ? "?" : "", getter, setter, omittable, ignorable);
                }
            };
        }
    }

    public static interface Violation {
        public Optional<Feature<?, ?>> feature();

        public String rule();

        public String message();

        public static Violation of(final String rule, final String message, final Feature<?, ?> setter) {
            return new Violation(){

                @Override
                public Optional<Feature<?, ?>> feature() {
                    return Optional.of(setter);
                }

                @Override
                public String rule() {
                    return rule;
                }

                @Override
                public String message() {
                    return message;
                }

                public String toString() {
                    return String.format("'%s': %s (%s)", setter.name(), message, rule);
                }
            };
        }

        public static Violation of(final String rule, final String message) {
            return new Violation(){

                @Override
                public Optional<Feature<?, ?>> feature() {
                    return Optional.empty();
                }

                @Override
                public String rule() {
                    return rule;
                }

                @Override
                public String message() {
                    return message;
                }

                public String toString() {
                    return String.format("%s (%s)", message, rule);
                }
            };
        }
    }

    public static interface Builder<T> {
        public List<Violation> verify();

        public <F> void set(Feature<T, F> var1, F var2);

        public T build();
    }
}

