/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jivesoftware.openfire.cluster.ClusterNodeInfo;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.jivesoftware.util.cache.CacheFactoryStrategy;
import org.jivesoftware.util.cache.ClusterTask;
import org.jivesoftware.util.cache.DefaultCache;

public class DefaultLocalCacheStrategy
implements CacheFactoryStrategy {
    private Map<Object, LockAndCount> locks = new ConcurrentHashMap<Object, LockAndCount>();

    @Override
    public boolean startCluster() {
        return false;
    }

    @Override
    public void stopCluster() {
    }

    @Override
    public Cache createCache(String name) {
        long maxSize = CacheFactory.getMaxCacheSize(name);
        long lifetime = CacheFactory.getMaxCacheLifetime(name);
        return new DefaultCache(name, maxSize, lifetime);
    }

    @Override
    public void destroyCache(Cache cache) {
        cache.clear();
    }

    @Override
    public boolean isSeniorClusterMember() {
        return true;
    }

    @Override
    public Collection<ClusterNodeInfo> getClusterNodesInfo() {
        return Collections.emptyList();
    }

    @Override
    public int getMaxClusterNodes() {
        return 0;
    }

    @Override
    public byte[] getSeniorClusterMemberID() {
        return null;
    }

    @Override
    public byte[] getClusterMemberID() {
        return new byte[0];
    }

    @Override
    public long getClusterTime() {
        return System.currentTimeMillis();
    }

    public void doClusterTask(ClusterTask task) {
    }

    public void doClusterTask(ClusterTask task, byte[] nodeID) {
        throw new IllegalStateException("Cluster service is not available");
    }

    public Collection<Object> doSynchronousClusterTask(ClusterTask task, boolean includeLocalMember) {
        return Collections.emptyList();
    }

    public Object doSynchronousClusterTask(ClusterTask task, byte[] nodeID) {
        throw new IllegalStateException("Cluster service is not available");
    }

    @Override
    public void updateCacheStats(Map<String, Cache> caches) {
    }

    @Override
    public String getPluginName() {
        return "local";
    }

    @Override
    public Lock getLock(Object key, Cache cache) {
        Object lockKey = key;
        if (key instanceof String) {
            lockKey = ((String)key).intern();
        }
        return new LocalLock(lockKey);
    }

    private void acquireLock(Object key) {
        ReentrantLock lock = this.lookupLockForAcquire(key);
        lock.lock();
    }

    private void releaseLock(Object key) {
        ReentrantLock lock = this.lookupLockForRelease(key);
        lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantLock lookupLockForAcquire(Object key) {
        Object object = key;
        synchronized (object) {
            LockAndCount lac = this.locks.get(key);
            if (lac == null) {
                lac = new LockAndCount(new ReentrantLock());
                lac.count = 1;
                this.locks.put(key, lac);
            } else {
                ++lac.count;
            }
            return lac.lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantLock lookupLockForRelease(Object key) {
        Object object = key;
        synchronized (object) {
            LockAndCount lac = this.locks.get(key);
            if (lac == null) {
                throw new IllegalStateException("No lock found for object " + key);
            }
            if (lac.count <= 1) {
                this.locks.remove(key);
            } else {
                --lac.count;
            }
            return lac.lock;
        }
    }

    @Override
    public ClusterNodeInfo getClusterNodeInfo(byte[] nodeID) {
        return null;
    }

    private static class LockAndCount {
        final ReentrantLock lock;
        int count;

        LockAndCount(ReentrantLock lock) {
            this.lock = lock;
        }
    }

    private class LocalLock
    implements Lock {
        private final Object key;

        LocalLock(Object key) {
            this.key = key;
        }

        @Override
        public void lock() {
            DefaultLocalCacheStrategy.this.acquireLock(this.key);
        }

        @Override
        public void unlock() {
            DefaultLocalCacheStrategy.this.releaseLock(this.key);
        }

        @Override
        public void lockInterruptibly() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }
    }
}

