/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LinkedList;
import org.jivesoftware.util.LinkedListNode;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.jivesoftware.util.cache.CacheSizes;
import org.jivesoftware.util.cache.CannotCalculateSizeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCache<K, V>
implements Cache<K, V> {
    private static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    private static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    private static final boolean allowNull = JiveGlobals.getBooleanProperty("cache.allow.null", true);
    private static final Logger Log = LoggerFactory.getLogger(DefaultCache.class);
    protected Map<K, CacheObject<V>> map;
    protected LinkedList<K> lastAccessedList;
    protected LinkedList<K> ageList;
    private long maxCacheSize;
    private int cacheSize = 0;
    protected long maxLifetime;
    protected long cacheHits;
    protected long cacheMisses = 0L;
    private String name;

    public DefaultCache(String name, long maxSize, long maxLifetime) {
        this.name = name;
        this.maxCacheSize = maxSize;
        this.maxLifetime = maxLifetime;
        this.map = new HashMap<K, CacheObject<V>>(103);
        this.lastAccessedList = new LinkedList();
        this.ageList = new LinkedList();
    }

    @Override
    public synchronized V put(K key, V value) {
        this.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        this.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        V answer = this.remove(key);
        int objectSize = 1;
        try {
            objectSize = CacheSizes.sizeOfAnything(value);
        }
        catch (CannotCalculateSizeException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
        if (this.maxCacheSize > 0L && (double)objectSize > (double)this.maxCacheSize * 0.9) {
            Log.warn("Cache: " + this.name + " -- object with key " + key + " is too large to fit in cache. Size is " + objectSize);
            return value;
        }
        this.cacheSize += objectSize;
        CacheObject<V> cacheObject = new CacheObject<V>(value, objectSize);
        this.map.put(key, cacheObject);
        LinkedListNode<K> lastAccessedNode = this.lastAccessedList.addFirst(key);
        cacheObject.lastAccessedListNode = lastAccessedNode;
        LinkedListNode<K> ageNode = this.ageList.addFirst(key);
        ageNode.timestamp = System.currentTimeMillis();
        cacheObject.ageListNode = ageNode;
        this.cullCache();
        return answer;
    }

    @Override
    public synchronized V get(Object key) {
        this.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        this.deleteExpiredEntries();
        CacheObject<V> cacheObject = this.map.get(key);
        if (cacheObject == null) {
            ++this.cacheMisses;
            return null;
        }
        ++this.cacheHits;
        ++cacheObject.readCount;
        cacheObject.lastAccessedListNode.remove();
        this.lastAccessedList.addFirst((K)cacheObject.lastAccessedListNode);
        return cacheObject.object;
    }

    @Override
    public synchronized V remove(Object key) {
        this.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        CacheObject<V> cacheObject = this.map.get(key);
        if (cacheObject == null) {
            return null;
        }
        this.map.remove(key);
        cacheObject.lastAccessedListNode.remove();
        cacheObject.ageListNode.remove();
        cacheObject.ageListNode = null;
        cacheObject.lastAccessedListNode = null;
        this.cacheSize -= cacheObject.size;
        return cacheObject.object;
    }

    @Override
    public synchronized void clear() {
        Object[] keys = this.map.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            this.remove(keys[i]);
        }
        this.map.clear();
        this.lastAccessedList.clear();
        this.lastAccessedList = new LinkedList();
        this.ageList.clear();
        this.ageList = new LinkedList();
        this.cacheSize = 0;
        this.cacheHits = 0L;
        this.cacheMisses = 0L;
    }

    @Override
    public int size() {
        this.deleteExpiredEntries();
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        this.deleteExpiredEntries();
        return this.map.isEmpty();
    }

    @Override
    public Collection<V> values() {
        this.deleteExpiredEntries();
        return new CacheObjectCollection(this.map.values());
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        this.deleteExpiredEntries();
        return this.map.containsKey(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (K key : map.keySet()) {
            V value = map.get(key);
            this.put(key, value);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        this.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        this.deleteExpiredEntries();
        Iterator<V> it = this.values().iterator();
        while (it.hasNext()) {
            if (!value.equals(it.next())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.deleteExpiredEntries();
        DefaultCache defaultCache = this;
        synchronized (defaultCache) {
            HashMap result = new HashMap();
            for (Map.Entry<K, CacheObject<V>> entry : this.map.entrySet()) {
                result.put(entry.getKey(), entry.getValue().object);
            }
            return result.entrySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        this.deleteExpiredEntries();
        DefaultCache defaultCache = this;
        synchronized (defaultCache) {
            return new HashSet<K>(this.map.keySet());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public long getCacheHits() {
        return this.cacheHits;
    }

    @Override
    public long getCacheMisses() {
        return this.cacheMisses;
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public long getMaxCacheSize() {
        return this.maxCacheSize;
    }

    @Override
    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        CacheFactory.setMaxSizeProperty(this.name, maxCacheSize);
        this.cullCache();
    }

    @Override
    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    @Override
    public void setMaxLifetime(long maxLifetime) {
        this.maxLifetime = maxLifetime;
        CacheFactory.setMaxLifetimeProperty(this.name, maxLifetime);
    }

    protected void deleteExpiredEntries() {
        if (this.maxLifetime <= 0L) {
            return;
        }
        LinkedListNode<K> node = this.ageList.getLast();
        if (node == null) {
            return;
        }
        long expireTime = System.currentTimeMillis() - this.maxLifetime;
        while (expireTime > node.timestamp) {
            this.remove(node.object);
            node = this.ageList.getLast();
            if (node != null) continue;
            return;
        }
    }

    protected final void cullCache() {
        if (this.maxCacheSize < 0L) {
            return;
        }
        int desiredSize = (int)((double)this.maxCacheSize * 0.97);
        if (this.cacheSize >= desiredSize) {
            this.deleteExpiredEntries();
            desiredSize = (int)((double)this.maxCacheSize * 0.9);
            if (this.cacheSize > desiredSize) {
                long t = System.currentTimeMillis();
                do {
                    this.remove(this.lastAccessedList.getLast().object);
                } while (this.cacheSize > desiredSize);
                t = System.currentTimeMillis() - t;
                Log.warn("Cache " + this.name + " was full, shrinked to 90% in " + t + "ms.");
            }
        }
    }

    private void checkNotNull(Object argument, String message) {
        try {
            if (argument == null) {
                throw new NullPointerException(message);
            }
        }
        catch (NullPointerException e) {
            if (allowNull) {
                Log.debug("Allowing storage of null within Cache: ", (Throwable)e);
            }
            throw e;
        }
    }

    private static class CacheObject<V> {
        public V object;
        public int size;
        public LinkedListNode<?> lastAccessedListNode;
        public LinkedListNode<?> ageListNode;
        public int readCount = 0;

        public CacheObject(V object, int size) {
            this.object = object;
            this.size = size;
        }
    }

    private final class CacheObjectCollection<V>
    implements Collection<V> {
        private Collection<CacheObject<V>> cachedObjects;

        private CacheObjectCollection(Collection<CacheObject<V>> cachedObjects) {
            this.cachedObjects = new ArrayList<CacheObject<V>>(cachedObjects);
        }

        @Override
        public int size() {
            return this.cachedObjects.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            DefaultCache.this.checkNotNull(o, DefaultCache.NULL_KEY_IS_NOT_ALLOWED);
            Iterator<V> it = this.iterator();
            while (it.hasNext()) {
                if (!it.next().equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                private final Iterator<CacheObject<V>> it;
                {
                    this.it = CacheObjectCollection.this.cachedObjects.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public V next() {
                    if (this.it.hasNext()) {
                        CacheObject object = this.it.next();
                        if (object == null) {
                            return null;
                        }
                        return object.object;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[this.size()];
            Iterator<V> it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                array[i] = it.next();
            }
            return array;
        }

        @Override
        public <V> V[] toArray(V[] a) {
            Iterator<V> it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                a[i++] = it.next();
            }
            return a;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            Iterator<?> it = c.iterator();
            while (it.hasNext()) {
                if (this.contains(it.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean add(V o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends V> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

