/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util.cache;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.util.cache.Cacheable;
import org.jivesoftware.util.cache.CannotCalculateSizeException;

public class CacheSizes {
    public static int sizeOfObject() {
        return 4;
    }

    public static int sizeOfString(String string) {
        if (string == null) {
            return 0;
        }
        return 4 + string.getBytes().length;
    }

    public static int sizeOfInt() {
        return 4;
    }

    public static int sizeOfChar() {
        return 2;
    }

    public static int sizeOfBoolean() {
        return 1;
    }

    public static int sizeOfLong() {
        return 8;
    }

    public static int sizeOfDouble() {
        return 8;
    }

    public static int sizeOfDate() {
        return 12;
    }

    public static int sizeOfMap(Map<?, ?> map) throws CannotCalculateSizeException {
        if (map == null) {
            return 0;
        }
        int size = 36;
        Set<Map.Entry<?, ?>> set = map.entrySet();
        for (Map.Entry<?, ?> entry : set) {
            size += CacheSizes.sizeOfAnything(entry.getKey());
            size += CacheSizes.sizeOfAnything(entry.getValue());
        }
        return size;
    }

    public static int sizeOfCollection(Collection list) throws CannotCalculateSizeException {
        if (list == null) {
            return 0;
        }
        int size = 36;
        Object[] values = list.toArray();
        for (int i = 0; i < values.length; ++i) {
            size += CacheSizes.sizeOfAnything(values[i]);
        }
        return size;
    }

    public static int sizeOfAnything(Object object) throws CannotCalculateSizeException {
        if (object == null) {
            return 0;
        }
        if (object instanceof Cacheable) {
            return ((Cacheable)object).getCachedSize();
        }
        if (object instanceof String) {
            return CacheSizes.sizeOfString((String)object);
        }
        if (object instanceof Long) {
            return CacheSizes.sizeOfLong();
        }
        if (object instanceof Integer) {
            return CacheSizes.sizeOfObject() + CacheSizes.sizeOfInt();
        }
        if (object instanceof Double) {
            return CacheSizes.sizeOfObject() + CacheSizes.sizeOfDouble();
        }
        if (object instanceof Boolean) {
            return CacheSizes.sizeOfObject() + CacheSizes.sizeOfBoolean();
        }
        if (object instanceof Map) {
            return CacheSizes.sizeOfMap((Map)object);
        }
        if (object instanceof long[]) {
            long[] array = (long[])object;
            return CacheSizes.sizeOfObject() + array.length * CacheSizes.sizeOfLong();
        }
        if (object instanceof Collection) {
            return CacheSizes.sizeOfCollection((Collection)object);
        }
        if (object instanceof byte[]) {
            byte[] array = (byte[])object;
            return CacheSizes.sizeOfObject() + array.length;
        }
        int size = 1;
        try {
            NullOutputStream out = new NullOutputStream();
            ObjectOutputStream outObj = new ObjectOutputStream(out);
            outObj.writeObject(object);
            size = out.size();
        }
        catch (IOException ioe) {
            throw new CannotCalculateSizeException(object);
        }
        return size;
    }

    private static class NullOutputStream
    extends OutputStream {
        int size = 0;

        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ++this.size;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.size += b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.size += len;
        }

        public int size() {
            return this.size;
        }
    }
}

