/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.interceptor.InterceptorManager;
import org.jivesoftware.openfire.interceptor.PacketInterceptor;
import org.jivesoftware.openfire.interceptor.PacketRejectedException;
import org.jivesoftware.openfire.server.RemoteServerManager;
import org.jivesoftware.openfire.session.DomainPair;
import org.jivesoftware.openfire.session.OutgoingServerSession;
import org.jivesoftware.openfire.session.Session;
import org.jivesoftware.util.cert.SANCertificateIdentityMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.Packet;

public class S2STestService {
    private static final Logger Log = LoggerFactory.getLogger(S2STestService.class);
    private Semaphore waitUntil;
    private String domain;

    public S2STestService(String domain) {
        this.domain = domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> run() throws Exception {
        this.waitUntil = new Semaphore(0);
        HashMap<String, String> results = new HashMap<String, String>();
        DomainPair pair = new DomainPair(XMPPServer.getInstance().getServerInfo().getXMPPDomain(), this.domain);
        SessionManager sessionManager = SessionManager.getInstance();
        for (Session session : sessionManager.getIncomingServerSessions(this.domain)) {
            session.close();
        }
        OutgoingServerSession outgoingServerSession = sessionManager.getOutgoingServerSession(pair);
        if (outgoingServerSession != null) {
            outgoingServerSession.close();
        }
        IQ iQ = new IQ(IQ.Type.get);
        iQ.setChildElement("ping", "urn:xmpp:ping");
        iQ.setFrom(pair.getLocal());
        iQ.setTo(this.domain);
        StringBuilder logs = new StringBuilder();
        Appender appender = this.interceptLogging(logs);
        S2SInterceptor interceptor = new S2SInterceptor(iQ);
        InterceptorManager.getInstance().addInterceptor(interceptor);
        try {
            Log.info("Sending server to server ping request to " + this.domain);
            XMPPServer.getInstance().getIQRouter().route(iQ);
            this.waitUntil.tryAcquire(RemoteServerManager.getSocketTimeout(), TimeUnit.MILLISECONDS);
            this.logSessionStatus();
            results.put("certs", this.getCertificates());
            results.put("stanzas", ((Object)interceptor).toString());
            results.put("logs", logs.toString());
            HashMap<String, String> hashMap = results;
            return hashMap;
        }
        finally {
            InterceptorManager.getInstance().removeInterceptor(interceptor);
            org.apache.log4j.Logger.getRootLogger().removeAppender(appender);
        }
    }

    private Appender interceptLogging(final StringBuilder logs) {
        WriterAppender appender = new WriterAppender(){

            public void append(LoggingEvent event) {
                logs.append(String.format("%s: %s: %s\n", new Date(event.getTimeStamp()).toString(), event.getLevel().toString(), event.getRenderedMessage()));
                String[] throwableInfo = event.getThrowableStrRep();
                if (throwableInfo != null) {
                    for (String line : throwableInfo) {
                        logs.append(line + "\n");
                    }
                }
            }
        };
        appender.setLayout((Layout)new PatternLayout("%d [%p|%c|%C{1}] %m%n"));
        appender.setThreshold((Priority)Level.ALL);
        appender.activateOptions();
        org.apache.log4j.Logger.getRootLogger().addAppender((Appender)appender);
        return appender;
    }

    private void logSessionStatus() {
        DomainPair pair = new DomainPair(XMPPServer.getInstance().getServerInfo().getXMPPDomain(), this.domain);
        OutgoingServerSession session = XMPPServer.getInstance().getSessionManager().getOutgoingServerSession(pair);
        if (session != null) {
            int connectionStatus = session.getStatus();
            switch (connectionStatus) {
                case 1: {
                    Log.info("Session is connected.");
                    break;
                }
                case -1: {
                    Log.info("Session is closed.");
                    break;
                }
                case 3: {
                    Log.info("Session is authenticated.");
                }
            }
        } else {
            Log.info("Failed to establish server to server session.");
        }
    }

    private String getCertificates() {
        DomainPair pair = new DomainPair(XMPPServer.getInstance().getServerInfo().getXMPPDomain(), this.domain);
        OutgoingServerSession session = XMPPServer.getInstance().getSessionManager().getOutgoingServerSession(pair);
        StringBuilder certs = new StringBuilder();
        if (session != null) {
            Certificate[] certificates;
            Log.info("Successfully negotiated TLS connection.");
            for (Certificate certificate : certificates = session.getPeerCertificates()) {
                X509Certificate x509cert = (X509Certificate)certificate;
                certs.append("--\nSubject: ");
                certs.append(x509cert.getSubjectDN());
                List<String> subjectAltNames = new SANCertificateIdentityMapping().mapIdentity(x509cert);
                if (!subjectAltNames.isEmpty()) {
                    certs.append("\nSubject Alternative Names: ");
                    for (String subjectAltName : subjectAltNames) {
                        certs.append("\n  ");
                        certs.append(subjectAltName);
                    }
                }
                certs.append("\nNot Before: ");
                certs.append(x509cert.getNotBefore());
                certs.append("\nNot After: ");
                certs.append(x509cert.getNotAfter());
                certs.append("\n\n-----BEGIN CERTIFICATE-----\n");
                certs.append(DatatypeConverter.printBase64Binary((byte[])certificate.getPublicKey().getEncoded()).replaceAll("(.{64})", "$1\n"));
                certs.append("\n-----END CERTIFICATE-----\n\n");
            }
        }
        return certs.toString();
    }

    private class S2SInterceptor
    implements PacketInterceptor {
        private StringBuilder xml = new StringBuilder();
        private final IQ ping;

        public S2SInterceptor(IQ ping) {
            this.ping = ping;
        }

        @Override
        public void interceptPacket(Packet packet, Session session, boolean incoming, boolean processed) throws PacketRejectedException {
            if (!processed && (this.ping.getTo().getDomain().equals(packet.getFrom().getDomain()) || this.ping.getTo().getDomain().equals(packet.getTo().getDomain()))) {
                IQ iq;
                this.xml.append(packet.toXML());
                this.xml.append('\n');
                if (packet instanceof IQ && (iq = (IQ)packet).isResponse() && this.ping.getID().equals(iq.getID()) && this.ping.getTo().equals((Object)iq.getFrom())) {
                    Log.info("Successful server to server response received.");
                    S2STestService.this.waitUntil.release();
                }
            }
        }

        public String toString() {
            return this.xml.toString();
        }
    }
}

