/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jivesoftware.util.JiveProperties;
import org.jivesoftware.util.cache.ClusterTask;
import org.jivesoftware.util.cache.ExternalizableUtil;

public class PropertyClusterEventTask
implements ClusterTask<Void> {
    private Type event;
    private String key;
    private String value;
    private boolean isEncrypted;

    public static PropertyClusterEventTask createPutTask(String key, String value, boolean isEncrypted) {
        PropertyClusterEventTask task = new PropertyClusterEventTask();
        task.event = Type.put;
        task.key = key;
        task.value = value;
        task.isEncrypted = isEncrypted;
        return task;
    }

    public static PropertyClusterEventTask createDeleteTask(String key) {
        PropertyClusterEventTask task = new PropertyClusterEventTask();
        task.event = Type.deleted;
        task.key = key;
        return task;
    }

    @Override
    public Void getResult() {
        return null;
    }

    @Override
    public void run() {
        if (Type.put == this.event) {
            JiveProperties.getInstance().localPut(this.key, this.value, this.isEncrypted);
        } else if (Type.deleted == this.event) {
            JiveProperties.getInstance().localRemove(this.key);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeInt(out, this.event.ordinal());
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.key);
        ExternalizableUtil.getInstance().writeBoolean(out, this.value != null);
        if (this.value != null) {
            ExternalizableUtil.getInstance().writeSafeUTF(out, this.value);
            ExternalizableUtil.getInstance().writeBoolean(out, this.isEncrypted);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.event = Type.values()[ExternalizableUtil.getInstance().readInt(in)];
        this.key = ExternalizableUtil.getInstance().readSafeUTF(in);
        if (ExternalizableUtil.getInstance().readBoolean(in)) {
            this.value = ExternalizableUtil.getInstance().readSafeUTF(in);
            this.isEncrypted = ExternalizableUtil.getInstance().readBoolean(in);
        }
    }

    private static enum Type {
        put,
        deleted;

    }
}

