/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log {
    private static final Logger Logger = LoggerFactory.getLogger(Log.class);
    public static final String LOG_DEBUG_ENABLED = "log.debug.enabled";

    @Deprecated
    public static boolean isErrorEnabled() {
        return Logger.isErrorEnabled();
    }

    @Deprecated
    public static boolean isDebugEnabled() {
        return Logger.isDebugEnabled();
    }

    public static void setDebugEnabled(boolean enabled) {
        Level newLevel = enabled ? Level.ALL : Level.INFO;
        LogManager.getRootLogger().setLevel(newLevel);
    }

    @Deprecated
    public static boolean isInfoEnabled() {
        return Logger.isInfoEnabled();
    }

    @Deprecated
    public static boolean isWarnEnabled() {
        return Logger.isWarnEnabled();
    }

    @Deprecated
    public static void debug(String s) {
        if (Log.isDebugEnabled()) {
            Logger.debug(s);
        }
    }

    @Deprecated
    public static void debug(Throwable throwable) {
        if (Log.isDebugEnabled()) {
            Logger.debug("", throwable);
        }
    }

    @Deprecated
    public static void debug(String s, Throwable throwable) {
        if (Log.isDebugEnabled()) {
            Logger.debug(s, throwable);
        }
    }

    public static void markDebugLogFile(String username) {
        String message = Log.getMarkMessage(username);
        Log.debug(message);
    }

    public static void rotateDebugLogFile() {
        File logFile = new File(Log.getLogDirectory(), "debug.log");
        Log.emptyFile(logFile);
    }

    @Deprecated
    public static void info(String s) {
        if (Log.isInfoEnabled()) {
            Logger.info(s);
        }
    }

    @Deprecated
    public static void info(Throwable throwable) {
        if (Log.isInfoEnabled()) {
            Logger.info("", throwable);
        }
    }

    @Deprecated
    public static void info(String s, Throwable throwable) {
        if (Log.isInfoEnabled()) {
            Logger.info(s, throwable);
        }
    }

    public static void markInfoLogFile(String username) {
        String message = Log.getMarkMessage(username);
        Log.info(message);
    }

    public static void rotateInfoLogFile() {
        File logFile = new File(Log.getLogDirectory(), "info.log");
        Log.emptyFile(logFile);
    }

    @Deprecated
    public static void warn(String s) {
        if (Log.isWarnEnabled()) {
            Logger.warn(s);
        }
    }

    @Deprecated
    public static void warn(Throwable throwable) {
        if (Log.isWarnEnabled()) {
            Logger.warn("", throwable);
        }
    }

    @Deprecated
    public static void warn(String s, Throwable throwable) {
        if (Log.isWarnEnabled()) {
            Logger.warn(s, throwable);
        }
    }

    public static void markWarnLogFile(String username) {
        String message = Log.getMarkMessage(username);
        Log.warn(message);
    }

    public static void rotateWarnLogFile() {
        File logFile = new File(Log.getLogDirectory(), "warn.log");
        Log.emptyFile(logFile);
    }

    @Deprecated
    public static void error(String s) {
        if (Log.isErrorEnabled()) {
            Logger.error(s);
            if (Log.isDebugEnabled()) {
                Log.printToStdErr(s, null);
            }
        }
    }

    @Deprecated
    public static void error(Throwable throwable) {
        if (Log.isErrorEnabled()) {
            Logger.error("", throwable);
            if (Log.isDebugEnabled()) {
                Log.printToStdErr(null, throwable);
            }
        }
    }

    @Deprecated
    public static void error(String s, Throwable throwable) {
        if (Log.isErrorEnabled()) {
            Logger.error(s, throwable);
            if (Log.isDebugEnabled()) {
                Log.printToStdErr(s, throwable);
            }
        }
    }

    public static void markErrorLogFile(String username) {
        String message = Log.getMarkMessage(username);
        Log.error(message);
    }

    public static void rotateErrorLogFile() {
        File logFile = new File(Log.getLogDirectory(), "error.log");
        Log.emptyFile(logFile);
    }

    public static void rotateAllLogFile() {
        File logFile = new File(Log.getLogDirectory(), "all.log");
        Log.emptyFile(logFile);
    }

    public static String getLogDirectory() {
        StringBuilder sb = new StringBuilder();
        sb.append(JiveGlobals.getHomeDirectory());
        if (!sb.substring(sb.length() - 1).startsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append("logs");
        sb.append(File.separator);
        return sb.toString();
    }

    private static String getMarkMessage(String username) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(username);
        args.add(JiveGlobals.formatDateTime(new Date()));
        return LocaleUtils.getLocalizedString("log.marker_inserted_by", args);
    }

    private static void printToStdErr(String s, Throwable throwable) {
        if (s != null) {
            System.err.println(s);
        }
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            System.err.print(sw.toString());
            System.err.print("\n");
        }
    }

    private static void emptyFile(File logFile) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(logFile));
            out.write("");
        }
        catch (IOException ex) {
            Log.warn("Could not empty file " + logFile.getName(), ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    Log.warn("Could not close file.", ex);
                }
            }
        }
    }

    static {
        PropertyEventDispatcher.addListener(new PropertyEventListener(){

            @Override
            public void propertySet(String property, Map<String, Object> params) {
                this.enableDebugLog(property, Boolean.parseBoolean(params.get("value").toString()));
            }

            @Override
            public void propertyDeleted(String property, Map<String, Object> params) {
                this.enableDebugLog(property, false);
            }

            @Override
            public void xmlPropertySet(String property, Map<String, Object> params) {
            }

            @Override
            public void xmlPropertyDeleted(String property, Map<String, Object> params) {
            }

            private void enableDebugLog(String property, boolean enabled) {
                if (Log.LOG_DEBUG_ENABLED.equals(property)) {
                    Log.setDebugEnabled(enabled);
                }
            }
        });
    }
}

