/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.io.IOException;
import java.util.ResourceBundle;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;

public class LocaleFilter
implements Filter {
    private ServletContext context;

    public void init(FilterConfig config) throws ServletException {
        this.context = config.getServletContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String pathInfo = ((HttpServletRequest)request).getPathInfo();
        if (pathInfo == null) {
            Config.set((ServletContext)this.context, (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)JiveGlobals.getLocale());
        } else {
            try {
                String[] parts = pathInfo.split("/");
                String pluginName = parts[1];
                ResourceBundle bundle = LocaleUtils.getPluginResourceBundle(pluginName);
                LocalizationContext ctx = new LocalizationContext(bundle, JiveGlobals.getLocale());
                Config.set((ServletRequest)request, (String)"javax.servlet.jsp.jstl.fmt.localizationContext", (Object)ctx);
            }
            catch (Exception e) {
                Config.set((ServletContext)this.context, (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)JiveGlobals.getLocale());
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

