/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;

public class FaviconServlet
extends HttpServlet {
    private static final String CONTENT_TYPE = "image/x-icon";
    private byte[] defaultBytes;
    private HttpClient client;
    private Cache<String, Integer> missesCache;
    private Cache<String, byte[]> hitsCache;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        HttpConnectionManagerParams params = this.client.getHttpConnectionManager().getParams();
        params.setConnectionTimeout(2000);
        params.setSoTimeout(2000);
        try {
            URL resource = config.getServletContext().getResource("/images/server_16x16.gif");
            this.defaultBytes = this.getImage(resource.toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.missesCache = CacheFactory.createCache("Favicon Misses");
        this.hitsCache = CacheFactory.createCache("Favicon Hits");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String host = request.getParameter("host");
        host = "gmail.com".equals(host) ? "google.com" : host;
        byte[] bytes = this.getImage(host, this.defaultBytes);
        if (bytes != null) {
            this.writeBytesToStream(bytes, response);
        }
    }

    private void writeBytesToStream(byte[] bytes, HttpServletResponse response) {
        response.setContentType(CONTENT_TYPE);
        try (ServletOutputStream sos = response.getOutputStream();){
            sos.write(bytes);
            sos.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private byte[] getImage(String host, byte[] defaultImage) {
        if (this.missesCache.get(host) != null && (Integer)this.missesCache.get(host) > 1) {
            return defaultImage;
        }
        if (this.hitsCache.containsKey(host)) {
            return (byte[])this.hitsCache.get(host);
        }
        byte[] bytes = this.getImage("http://" + host + "/favicon.ico");
        if (bytes == null) {
            if (this.missesCache.get(host) != null) {
                this.missesCache.put(host, 2);
            } else {
                this.missesCache.put(host, 1);
            }
            bytes = defaultImage;
        } else {
            this.hitsCache.put(host, bytes);
        }
        return bytes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getImage(String url) {
        try {
            GetMethod get = new GetMethod(url);
            get.setFollowRedirects(true);
            int response = this.client.executeMethod((HttpMethod)get);
            if (response >= 400) return null;
            return get.getResponseBody();
        }
        catch (IllegalStateException e) {
            try {
                URLConnection urlConnection = new URL(url).openConnection();
                urlConnection.setReadTimeout(1000);
                urlConnection.connect();
                try (DataInputStream di = new DataInputStream(urlConnection.getInputStream());){
                    int len;
                    ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                    DataOutputStream out = new DataOutputStream(byteStream);
                    byte[] b = new byte[1024];
                    while ((len = di.read(b)) != -1) {
                        out.write(b, 0, len);
                    }
                    out.flush();
                    byte[] byArray = byteStream.toByteArray();
                    return byArray;
                }
            }
            catch (IOException ioe) {
                return null;
            }
        }
        catch (IOException ioe) {
            return null;
        }
    }
}

